/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.network;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import team.tnt.collectorsalbum.common.AlbumCategory;
import team.tnt.collectorsalbum.common.AlbumCategoryType;
import team.tnt.collectorsalbum.common.card.AlbumCard;
import team.tnt.collectorsalbum.common.card.AlbumCardType;
import team.tnt.collectorsalbum.common.resource.AlbumBonusManager;
import team.tnt.collectorsalbum.common.resource.AlbumCardManager;
import team.tnt.collectorsalbum.common.resource.AlbumCategoryManager;
import team.tnt.collectorsalbum.common.resource.CardPackDropManager;
import team.tnt.collectorsalbum.common.resource.SynchronizedResource;
import team.tnt.collectorsalbum.common.resource.bonus.AlbumBonus;
import team.tnt.collectorsalbum.common.resource.bonus.AlbumBonusType;
import team.tnt.collectorsalbum.platform.network.PlatformNetworkManager;

public record S2C_SendDatapackResources(List<AlbumCard> cards, List<AlbumCategory> categories, List<AlbumBonus> bonuses, List<CardPackDropManager.DropEntry> drops) implements CustomPacketPayload
{
    private static final ResourceLocation IDENTIFIER = PlatformNetworkManager.generatePacketIdentifier("collectorsalbum", S2C_SendDatapackResources.class);
    public static final CustomPacketPayload.Type<S2C_SendDatapackResources> TYPE = new CustomPacketPayload.Type(IDENTIFIER);
    public static final StreamCodec<FriendlyByteBuf, S2C_SendDatapackResources> CODEC = StreamCodec.of((buf, payload) -> payload.encode((FriendlyByteBuf)buf), S2C_SendDatapackResources::decode);

    public S2C_SendDatapackResources() {
        this(AlbumCardManager.getInstance().getDataForSync(), AlbumCategoryManager.getInstance().getDataForSync(), AlbumBonusManager.getInstance().getDataForSync(), CardPackDropManager.getInstance().getDataForSync());
    }

    private S2C_SendDatapackResources(ValueHolder<AlbumCard> cardHolder, ValueHolder<AlbumCategory> categoryHolder, ValueHolder<AlbumBonus> bonusHolder, ValueHolder<CardPackDropManager.DropEntry> dropHolder) {
        this(cardHolder.values, categoryHolder.values, bonusHolder.values, dropHolder.values);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    private void encode(FriendlyByteBuf buffer) {
        this.encodeWithCodec(buffer, AlbumCardType.INSTANCE_CODEC, this.cards());
        this.encodeWithCodec(buffer, AlbumCategoryType.INSTANCE_CODEC, this.categories());
        this.encodeWithCodec(buffer, AlbumBonusType.INSTANCE_CODEC, this.bonuses());
        this.encodeWithCodec(buffer, CardPackDropManager.DropEntry.CODEC, this.drops());
    }

    private <T> void encodeWithCodec(FriendlyByteBuf buf, Codec<T> codec, List<T> list) {
        ValueHolder<T> holder = new ValueHolder<T>(list);
        Codec<ValueHolder<T>> valueCodec = ValueHolder.codec(codec);
        DataResult result = valueCodec.encodeStart((DynamicOps)NbtOps.INSTANCE, holder);
        Tag tag = (Tag)result.getOrThrow();
        buf.writeNbt(tag);
    }

    private static S2C_SendDatapackResources decode(FriendlyByteBuf buffer) {
        return new S2C_SendDatapackResources(S2C_SendDatapackResources.decodeWithCodec(buffer, AlbumCardType.INSTANCE_CODEC, AlbumCardManager.getInstance()), S2C_SendDatapackResources.decodeWithCodec(buffer, AlbumCategoryType.INSTANCE_CODEC, AlbumCategoryManager.getInstance()), S2C_SendDatapackResources.decodeWithCodec(buffer, AlbumBonusType.INSTANCE_CODEC, AlbumBonusManager.getInstance()), S2C_SendDatapackResources.decodeWithCodec(buffer, CardPackDropManager.DropEntry.CODEC, CardPackDropManager.getInstance()));
    }

    private static <T> ValueHolder<T> decodeWithCodec(FriendlyByteBuf buffer, Codec<T> codec, SynchronizedResource<T> listener) {
        Codec<ValueHolder<T>> valueCodec = ValueHolder.codec(codec);
        CompoundTag tag = buffer.readNbt();
        DataResult result = valueCodec.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag);
        ValueHolder holder = (ValueHolder)result.getOrThrow();
        listener.receiveNetworkData(holder.values());
        return holder;
    }

    public void onDataReceived(Player player) {
    }

    private record ValueHolder<T>(List<T> values) {
        static <T> Codec<ValueHolder<T>> codec(Codec<T> element) {
            return RecordCodecBuilder.create(instance -> instance.group((App)element.listOf().fieldOf("valueList").forGetter(t -> t.values)).apply((Applicative)instance, ValueHolder::new));
        }
    }
}

