/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.platform.network;

import java.util.List;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import team.tnt.collectorsalbum.platform.network.Network;
import team.tnt.collectorsalbum.platform.network.PacketHolder;
import team.tnt.collectorsalbum.platform.network.PlatformNetworkManager;

public class NeoforgeNetwork
implements Network {
    public static void subscribeRegistryEvent(IEventBus eventBus, PlatformNetworkManager manager) {
        eventBus.addListener(EventPriority.NORMAL, false, RegisterPayloadHandlersEvent.class, event -> {
            PayloadRegistrar registrar = event.registrar(manager.identifier().getNamespace());
            manager.bindRef(c2s -> c2s.forEach(holder -> NeoforgeNetwork.registerInternalC2S(registrar, holder)), s2c -> s2c.forEach(holder -> NeoforgeNetwork.registerInternalS2C(registrar, holder)));
        });
    }

    @Override
    public void initialize(ResourceLocation identifier, List<PacketHolder<?, ?>> c2s, List<PacketHolder<?, ?>> s2c) {
        throw new UnsupportedOperationException("Cannot automatically bind network packets on NeoForge platform. Use specific events to register your packets instead!");
    }

    @Override
    public void sendClientMessage(ServerPlayer player, CustomPacketPayload payload) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendServerMessage(CustomPacketPayload payload) {
        PacketDistributor.sendToServer((CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static <P extends CustomPacketPayload> void registerInternalC2S(PayloadRegistrar registrar, PacketHolder<P, ?> holder) {
        registrar.playToServer(holder.type(), holder.codec(), (payload, ctx) -> {
            if (holder.handler() != null) {
                ctx.enqueueWork(() -> holder.handler().handle(payload, ctx.player()));
            }
        });
    }

    private static <P extends CustomPacketPayload> void registerInternalS2C(PayloadRegistrar registrar, PacketHolder<P, ?> holder) {
        registrar.playToClient(holder.type(), holder.codec(), (payload, ctx) -> {
            if (holder.handler() != null) {
                ctx.enqueueWork(() -> holder.handler().handle(payload, ctx.player()));
            }
        });
    }
}

