/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.platform.network;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import team.tnt.collectorsalbum.platform.Identifiable;
import team.tnt.collectorsalbum.platform.JavaServiceLoader;
import team.tnt.collectorsalbum.platform.network.Network;
import team.tnt.collectorsalbum.platform.network.PacketDirection;
import team.tnt.collectorsalbum.platform.network.PacketHandler;
import team.tnt.collectorsalbum.platform.network.PacketHolder;

public final class PlatformNetworkManager
implements Identifiable {
    public static final Network NETWORK = JavaServiceLoader.loadService(Network.class);
    private final ResourceLocation identifier;
    private Registry registry = new Registry();

    private PlatformNetworkManager(ResourceLocation identifier) {
        this.identifier = identifier;
    }

    @Override
    public ResourceLocation identifier() {
        return this.identifier;
    }

    public static ResourceLocation generatePacketIdentifier(Identifiable identifiable, Class<? extends CustomPacketPayload> type) {
        return PlatformNetworkManager.generatePacketIdentifier(identifiable.identifier().getNamespace(), type);
    }

    public static ResourceLocation generatePacketIdentifier(ResourceLocation identifier, Class<? extends CustomPacketPayload> type) {
        return PlatformNetworkManager.generatePacketIdentifier(identifier.getNamespace(), type);
    }

    public static ResourceLocation generatePacketIdentifier(String namespace, Class<? extends CustomPacketPayload> type) {
        return ResourceLocation.fromNamespaceAndPath((String)namespace, (String)type.getSimpleName().replaceAll("([A-Z])", "_$1").toLowerCase(Locale.ROOT));
    }

    public static PlatformNetworkManager create(ResourceLocation identifier) {
        return new PlatformNetworkManager(identifier);
    }

    public static PlatformNetworkManager create(String namespace) {
        return PlatformNetworkManager.create(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)"network"));
    }

    public <P extends CustomPacketPayload, BUF extends FriendlyByteBuf> void registerPacket(PacketDirection direction, Class<P> payloadType, CustomPacketPayload.Type<P> type, StreamCodec<BUF, P> codec) {
        this.registerPacket(direction, payloadType, type, codec, null);
    }

    public <P extends CustomPacketPayload, BUF extends FriendlyByteBuf> void registerPacket(PacketDirection direction, Class<P> payloadType, CustomPacketPayload.Type<P> type, StreamCodec<BUF, P> codec, PacketHandler<P> handler) {
        this.registry.register(direction, new PacketHolder<P, BUF>(payloadType, type, codec, handler));
    }

    public void bind() {
        ArrayList c2s = new ArrayList();
        ArrayList s2c = new ArrayList();
        this.bindRef(c2s::addAll, s2c::addAll);
        NETWORK.initialize(this.identifier, c2s, s2c);
    }

    public void bindRef(Consumer<List<PacketHolder<?, ?>>> c2sPackets, Consumer<List<PacketHolder<?, ?>>> s2cPackets) {
        List<PacketHolder<?, ?>> c2s = this.registry.sidePackets.get((Object)PacketDirection.CLIENT_TO_SERVER);
        List<PacketHolder<?, ?>> s2c = this.registry.sidePackets.get((Object)PacketDirection.SERVER_TO_CLIENT);
        if (!c2s.isEmpty()) {
            c2sPackets.accept(c2s);
        }
        if (!s2c.isEmpty()) {
            s2cPackets.accept(s2c);
        }
        this.registry = null;
    }

    private static final class Registry {
        private final EnumMap<PacketDirection, List<PacketHolder<?, ?>>> sidePackets = new EnumMap(PacketDirection.class);

        private Registry() {
            this.sidePackets.put(PacketDirection.CLIENT_TO_SERVER, new ArrayList());
            this.sidePackets.put(PacketDirection.SERVER_TO_CLIENT, new ArrayList());
        }

        void register(PacketDirection direction, PacketHolder<?, ?> packet) {
            this.sidePackets.get((Object)direction).add(packet);
        }
    }
}

