/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.platform.registration;

import com.mojang.serialization.Codec;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import team.tnt.collectorsalbum.platform.Platform;
import team.tnt.collectorsalbum.platform.registration.PlatformRegistryImpl;

public interface PlatformRegistry<T> {
    public static <T> PlatformRegistry<T> create(Registry<T> registry, String namespace) {
        return new PlatformRegistryImpl(() -> registry, namespace);
    }

    public static <T> PlatformRegistry<T> create(RegistryReference<T> reference, String namespace) {
        return new PlatformRegistryImpl(reference, namespace);
    }

    public static MenuHelper createMenuHelper(final PlatformRegistry<MenuType<?>> menuTypeRegistry) {
        return new MenuHelper(){

            @Override
            public <M extends AbstractContainerMenu, D> Reference<MenuType<M>> register(String name, Platform.MenuFactory<M, D> factory, StreamCodec<? super FriendlyByteBuf, D> codec) {
                return menuTypeRegistry.register(name, () -> Platform.INSTANCE.createMenu(factory, codec));
            }
        };
    }

    public <R extends T> Reference<R> register(String var1, Supplier<R> var2);

    public <R extends T> Reference<R> register(String var1, Function<ResourceLocation, R> var2);

    public <R extends T> void bindRef(BiConsumer<ResourceLocation, Reference<R>> var1);

    public void bind();

    public boolean is(ResourceKey<?> var1);

    public ResourceKey<? extends Registry<T>> registryKey();

    @FunctionalInterface
    public static interface MenuHelper {
        public <M extends AbstractContainerMenu, D> Reference<MenuType<M>> register(String var1, Platform.MenuFactory<M, D> var2, StreamCodec<? super FriendlyByteBuf, D> var3);
    }

    @FunctionalInterface
    public static interface RegistryReference<T>
    extends Reference<Registry<T>> {
        default public Codec<T> byNameCodec() {
            return ((Registry)this.get()).byNameCodec();
        }
    }

    @FunctionalInterface
    public static interface Reference<T>
    extends Supplier<T> {
    }
}

