/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.platform.registration;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import team.tnt.collectorsalbum.platform.registration.PlatformRegistry;
import team.tnt.collectorsalbum.platform.registration.RegistryElement;

final class PlatformRegistryImpl<T>
implements PlatformRegistry<T> {
    private final Supplier<Registry<T>> registryRef;
    private final String namespace;
    private Map<ResourceLocation, RegistryElement<T, ?>> registeredRefs = new HashMap();

    PlatformRegistryImpl(Supplier<Registry<T>> registryRef, String namespace) {
        this.registryRef = registryRef;
        this.namespace = namespace;
    }

    @Override
    public <R extends T> PlatformRegistry.Reference<R> register(String elementId, Supplier<R> ref) {
        RegistryElement value;
        ResourceLocation key = ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)elementId);
        if (this.registeredRefs.put(key, value = new RegistryElement(ref)) != null) {
            throw new IllegalArgumentException("Duplicate key: " + String.valueOf(key));
        }
        return value;
    }

    @Override
    public <R extends T> PlatformRegistry.Reference<R> register(String elementId, Function<ResourceLocation, R> ref) {
        Supplier<Object> supplier;
        RegistryElement value;
        ResourceLocation key = ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)elementId);
        if (this.registeredRefs.put(key, value = new RegistryElement(supplier = () -> ref.apply(key))) != null) {
            throw new IllegalArgumentException("Duplicate key: " + String.valueOf(key));
        }
        return value;
    }

    @Override
    public <R extends T> void bindRef(BiConsumer<ResourceLocation, PlatformRegistry.Reference<R>> refConsumer) {
        for (Map.Entry<ResourceLocation, RegistryElement<T, ?>> entry : this.registeredRefs.entrySet()) {
            refConsumer.accept(entry.getKey(), entry.getValue());
        }
        this.registeredRefs = null;
    }

    @Override
    public void bind() {
        for (Map.Entry<ResourceLocation, RegistryElement<T, ?>> entry : this.registeredRefs.entrySet()) {
            this.bindInternal(entry.getKey(), entry.getValue());
        }
        this.registeredRefs = null;
    }

    @Override
    public boolean is(ResourceKey<?> resourceKey) {
        return this.registryKey().equals(resourceKey);
    }

    @Override
    public ResourceKey<? extends Registry<T>> registryKey() {
        return this.registryRef.get().key();
    }

    private <R extends T> void bindInternal(ResourceLocation identifier, RegistryElement<T, R> element) {
        Registry.register(this.registryRef.get(), (ResourceLocation)identifier, element.get());
    }
}

