/*
 * Decompiled with CFR 0.152.
 */
package team.tnt.collectorsalbum.platform.resource;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;
import team.tnt.collectorsalbum.platform.resource.PlatformBaseReloadListener;

public abstract class PlatformGsonReloadListener
extends PlatformBaseReloadListener<Map<ResourceLocation, JsonElement>> {
    protected final Gson gson;
    protected final String directory;

    public PlatformGsonReloadListener(Gson gson, String directory) {
        this.gson = gson;
        this.directory = directory;
    }

    @Override
    public final Map<ResourceLocation, JsonElement> prepare(ResourceManager manager, ProfilerFiller profiler) {
        HashMap<ResourceLocation, JsonElement> resources = new HashMap<ResourceLocation, JsonElement>();
        FileToIdConverter idConverter = FileToIdConverter.json((String)this.directory);
        for (Map.Entry entry : idConverter.listMatchingResources(manager).entrySet()) {
            ResourceLocation fileResourcePath = (ResourceLocation)entry.getKey();
            ResourceLocation identifier = idConverter.fileToId(fileResourcePath);
            try {
                BufferedReader reader = ((Resource)entry.getValue()).openAsReader();
                try {
                    JsonElement json = (JsonElement)GsonHelper.fromJson((Gson)this.gson, (Reader)reader, JsonElement.class);
                    if (resources.put(identifier, json) == null) continue;
                    throw new IllegalStateException("Duplicate data file: " + String.valueOf(identifier));
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException e) {
                LOGGER.error((Message)new FormattedMessage("Could not parse data file {} from {}", (Object)identifier, (Object)fileResourcePath), e);
            }
        }
        return resources;
    }
}

