/*
 * Decompiled with CFR 0.152.
 */
package guideme.indices;

import com.google.gson.stream.JsonWriter;
import guideme.PageAnchor;
import guideme.compiler.ParsedGuidePage;
import guideme.indices.MultiValuedIndex;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CategoryIndex
extends MultiValuedIndex<String, PageAnchor> {
    private static final Logger LOG = LoggerFactory.getLogger(CategoryIndex.class);

    public CategoryIndex() {
        super("Categories", CategoryIndex::getCategories, JsonWriter::value, (writer, value) -> writer.value(value.toString()));
    }

    private static List<Pair<String, PageAnchor>> getCategories(ParsedGuidePage page) {
        Object categoriesNode = page.getFrontmatter().additionalProperties().get("categories");
        if (categoriesNode == null) {
            return List.of();
        }
        if (!(categoriesNode instanceof List)) {
            LOG.warn("Page {} contains malformed categories frontmatter", (Object)page.getId());
            return List.of();
        }
        List categoryList = (List)categoriesNode;
        PageAnchor anchor = new PageAnchor(page.getId(), null);
        ArrayList<Pair<String, PageAnchor>> categories = new ArrayList<Pair<String, PageAnchor>>();
        for (Object listEntry : categoryList) {
            if (listEntry instanceof String) {
                String categoryString = (String)listEntry;
                categories.add((Pair<String, PageAnchor>)Pair.of((Object)categoryString, (Object)anchor));
                continue;
            }
            LOG.warn("Page {} contains a malformed categories frontmatter entry: {}", (Object)page.getId(), listEntry);
        }
        return categories;
    }
}

