/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis;

import guideme.internal.shaded.lucene.analysis.AbstractAnalysisFactory;
import guideme.internal.shaded.lucene.analysis.AnalysisSPILoader;
import guideme.internal.shaded.lucene.analysis.TokenStream;
import java.util.Map;
import java.util.Set;

public abstract class TokenFilterFactory
extends AbstractAnalysisFactory {
    public static TokenFilterFactory forName(String name, Map<String, String> args) {
        return Holder.getLoader().newInstance(name, args);
    }

    public static Class<? extends TokenFilterFactory> lookupClass(String name) {
        return Holder.getLoader().lookupClass(name);
    }

    public static Set<String> availableTokenFilters() {
        return Holder.getLoader().availableServices();
    }

    public static String findSPIName(Class<? extends TokenFilterFactory> serviceClass) {
        try {
            return AnalysisSPILoader.lookupSPIName(serviceClass);
        }
        catch (IllegalAccessException | IllegalStateException | NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void reloadTokenFilters(ClassLoader classloader) {
        Holder.getLoader().reload(classloader);
    }

    protected TokenFilterFactory() {
    }

    protected TokenFilterFactory(Map<String, String> args) {
        super(args);
    }

    public abstract TokenStream create(TokenStream var1);

    public TokenStream normalize(TokenStream input) {
        return input;
    }

    private static final class Holder {
        private static final AnalysisSPILoader<TokenFilterFactory> LOADER = new AnalysisSPILoader<TokenFilterFactory>(TokenFilterFactory.class);

        private Holder() {
        }

        static AnalysisSPILoader<TokenFilterFactory> getLoader() {
            if (LOADER == null) {
                throw new IllegalStateException("You tried to lookup a TokenFilterFactory by name before all factories could be initialized. This likely happens if you call TokenFilterFactory#forName from a TokenFilterFactory's ctor.");
            }
            return LOADER;
        }
    }
}

