/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.analysis.morph;

import guideme.internal.shaded.lucene.analysis.morph.ConnectionCosts;
import guideme.internal.shaded.lucene.analysis.morph.Dictionary;
import guideme.internal.shaded.lucene.analysis.morph.MorphData;
import guideme.internal.shaded.lucene.analysis.morph.TokenType;
import guideme.internal.shaded.lucene.analysis.morph.Viterbi;
import java.util.HashMap;
import java.util.Map;

public class GraphvizFormatter<T extends MorphData> {
    private static final String BOS_LABEL = "BOS";
    private static final String EOS_LABEL = "EOS";
    private static final String FONT_NAME = "Helvetica";
    private final ConnectionCosts costs;
    private final Map<String, String> bestPathMap;
    private final StringBuilder sb = new StringBuilder();

    public GraphvizFormatter(ConnectionCosts costs) {
        this.costs = costs;
        this.bestPathMap = new HashMap<String, String>();
        this.sb.append(this.formatHeader());
        this.sb.append("  init [style=invis]\n");
        this.sb.append("  init -> 0.0 [label=\"BOS\"]\n");
    }

    public String finish() {
        this.sb.append(this.formatTrailer());
        return this.sb.toString();
    }

    public void onBacktrace(DictionaryProvider<T> dictProvider, Viterbi.WrappedPositionArray<? extends Viterbi.Position> positions, int lastBackTracePos, Viterbi.Position endPosData, int fromIDX, char[] fragment, boolean isEnd) {
        this.setBestPathMap(positions, lastBackTracePos, endPosData, fromIDX);
        this.sb.append(this.formatNodes(dictProvider, positions, lastBackTracePos, endPosData, fragment));
        if (isEnd) {
            this.sb.append("  fini [style=invis]\n");
            this.sb.append("  ");
            this.sb.append(this.getNodeID(endPosData.getPos(), fromIDX));
            this.sb.append(" -> fini [label=\"EOS\"]");
        }
    }

    private void setBestPathMap(Viterbi.WrappedPositionArray<? extends Viterbi.Position> positions, int startPos, Viterbi.Position endPosData, int fromIDX) {
        this.bestPathMap.clear();
        int pos = endPosData.getPos();
        int bestIDX = fromIDX;
        while (pos > startPos) {
            Viterbi.Position posData = positions.get(pos);
            int backPos = posData.getBackPos(bestIDX);
            int backIDX = posData.getBackIndex(bestIDX);
            String toNodeID = this.getNodeID(pos, bestIDX);
            String fromNodeID = this.getNodeID(backPos, backIDX);
            assert (!this.bestPathMap.containsKey(fromNodeID));
            assert (!this.bestPathMap.containsValue(toNodeID));
            this.bestPathMap.put(fromNodeID, toNodeID);
            pos = backPos;
            bestIDX = backIDX;
        }
    }

    private String formatNodes(DictionaryProvider<T> dictProvider, Viterbi.WrappedPositionArray<? extends Viterbi.Position> positions, int startPos, Viterbi.Position endPosData, char[] fragment) {
        int idx;
        Viterbi.Position posData;
        int pos;
        StringBuilder sb = new StringBuilder();
        for (pos = startPos + 1; pos <= endPosData.getPos(); ++pos) {
            posData = positions.get(pos);
            for (idx = 0; idx < posData.getCount(); ++idx) {
                sb.append("  ");
                sb.append(this.getNodeID(pos, idx));
                sb.append(" [label=\"");
                sb.append(pos);
                sb.append(": ");
                sb.append(posData.getLastRightID(idx));
                sb.append("\"]\n");
            }
        }
        for (pos = endPosData.getPos(); pos > startPos; --pos) {
            posData = positions.get(pos);
            for (idx = 0; idx < posData.getCount(); ++idx) {
                Viterbi.Position backPosData = positions.get(posData.getBackPos(idx));
                String toNodeID = this.getNodeID(pos, idx);
                String fromNodeID = this.getNodeID(posData.getBackPos(idx), posData.getBackIndex(idx));
                sb.append("  ");
                sb.append(fromNodeID);
                sb.append(" -> ");
                sb.append(toNodeID);
                String attrs = toNodeID.equals(this.bestPathMap.get(fromNodeID)) ? " color=\"#40e050\" fontcolor=\"#40a050\" penwidth=3 fontsize=20" : "";
                Dictionary<T> dict = dictProvider.get(posData.getBackType(idx));
                int wordCost = dict.getWordCost(posData.getBackID(idx));
                int bgCost = this.costs.get(backPosData.getLastRightID(posData.getBackIndex(idx)), dict.getLeftId(posData.getBackID(idx)));
                String surfaceForm = new String(fragment, posData.getBackPos(idx) - startPos, pos - posData.getBackPos(idx));
                sb.append(" [label=\"");
                sb.append(surfaceForm);
                sb.append(' ');
                sb.append(wordCost);
                if (bgCost >= 0) {
                    sb.append('+');
                }
                sb.append(bgCost);
                sb.append("\"");
                sb.append(attrs);
                sb.append("]\n");
            }
        }
        return sb.toString();
    }

    private String formatHeader() {
        return "digraph viterbi {\n  graph [ fontsize=30 labelloc=\"t\" label=\"\" splines=true overlap=false rankdir = \"LR\"];\n  edge [ fontname=\"Helvetica\" fontcolor=\"red\" color=\"#606060\" ]\n  node [ style=\"filled\" fillcolor=\"#e8e8f0\" shape=\"Mrecord\" fontname=\"Helvetica\" ]\n";
    }

    private String formatTrailer() {
        return "}";
    }

    private String getNodeID(int pos, int idx) {
        return pos + "." + idx;
    }

    @FunctionalInterface
    public static interface DictionaryProvider<T extends MorphData> {
        public Dictionary<? extends T> get(TokenType var1);
    }
}

