/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.collation;

import guideme.internal.shaded.lucene.document.Field;
import guideme.internal.shaded.lucene.document.SortedDocValuesField;
import guideme.internal.shaded.lucene.util.BytesRef;
import java.text.Collator;

public final class CollationDocValuesField
extends Field {
    private final String name;
    private final Collator collator;
    private final BytesRef bytes = new BytesRef();

    public CollationDocValuesField(String name, Collator collator) {
        super(name, SortedDocValuesField.TYPE);
        this.name = name;
        this.collator = (Collator)collator.clone();
        this.fieldsData = this.bytes;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public void setStringValue(String value) {
        this.bytes.bytes = this.collator.getCollationKey(value).toByteArray();
        this.bytes.offset = 0;
        this.bytes.length = this.bytes.bytes.length;
    }
}

