/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queries.spans;

import guideme.internal.shaded.lucene.queries.spans.SpanQuery;
import guideme.internal.shaded.lucene.queries.spans.SpanWeight;
import guideme.internal.shaded.lucene.search.BooleanClause;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.search.QueryVisitor;
import guideme.internal.shaded.lucene.search.ScoreMode;
import java.io.IOException;
import java.util.Objects;

public final class FieldMaskingSpanQuery
extends SpanQuery {
    private final SpanQuery maskedQuery;
    private final String field;

    public FieldMaskingSpanQuery(SpanQuery maskedQuery, String maskedField) {
        this.maskedQuery = Objects.requireNonNull(maskedQuery);
        this.field = Objects.requireNonNull(maskedField);
    }

    @Override
    public String getField() {
        return this.field;
    }

    public SpanQuery getMaskedQuery() {
        return this.maskedQuery;
    }

    @Override
    public SpanWeight createWeight(IndexSearcher searcher, ScoreMode scoreMode, float boost) throws IOException {
        return this.maskedQuery.createWeight(searcher, scoreMode, boost);
    }

    @Override
    public Query rewrite(IndexSearcher indexSearcher) throws IOException {
        SpanQuery rewritten = (SpanQuery)this.maskedQuery.rewrite(indexSearcher);
        if (rewritten != this.maskedQuery) {
            return new FieldMaskingSpanQuery(rewritten, this.field);
        }
        return super.rewrite(indexSearcher);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            this.maskedQuery.visit(visitor.getSubVisitor(BooleanClause.Occur.MUST, this));
        }
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("mask(");
        buffer.append(this.maskedQuery.toString(field));
        buffer.append(")");
        buffer.append(" as ");
        buffer.append(this.field);
        return buffer.toString();
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((FieldMaskingSpanQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(FieldMaskingSpanQuery other) {
        return this.getField().equals(other.getField()) && this.getMaskedQuery().equals(other.getMaskedQuery());
    }

    @Override
    public int hashCode() {
        return this.classHash() ^ this.getMaskedQuery().hashCode() ^ this.getField().hashCode();
    }
}

