/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queryparser.xml.builders;

import guideme.internal.shaded.lucene.analysis.Analyzer;
import guideme.internal.shaded.lucene.analysis.TokenStream;
import guideme.internal.shaded.lucene.analysis.tokenattributes.CharTermAttribute;
import guideme.internal.shaded.lucene.queries.mlt.MoreLikeThisQuery;
import guideme.internal.shaded.lucene.queryparser.xml.DOMUtils;
import guideme.internal.shaded.lucene.queryparser.xml.ParserException;
import guideme.internal.shaded.lucene.queryparser.xml.QueryBuilder;
import guideme.internal.shaded.lucene.search.BoostQuery;
import guideme.internal.shaded.lucene.search.Query;
import java.io.IOException;
import java.util.HashSet;
import org.w3c.dom.Element;

public class LikeThisQueryBuilder
implements QueryBuilder {
    private static final int DEFAULT_MAX_QUERY_TERMS = 20;
    private static final int DEFAULT_MIN_TERM_FREQUENCY = 1;
    private static final float DEFAULT_PERCENT_TERMS_TO_MATCH = 30.0f;
    private final Analyzer analyzer;
    private final String[] defaultFieldNames;

    public LikeThisQueryBuilder(Analyzer analyzer, String[] defaultFieldNames) {
        this.analyzer = analyzer;
        this.defaultFieldNames = defaultFieldNames;
    }

    @Override
    public Query getQuery(Element e) throws ParserException {
        String fieldsList = e.getAttribute("fieldNames");
        String[] fields = this.defaultFieldNames;
        if (fieldsList != null && fieldsList.trim().length() > 0) {
            fields = fieldsList.trim().split(",");
            for (int i = 0; i < fields.length; ++i) {
                fields[i] = fields[i].trim();
            }
        }
        String stopWords = e.getAttribute("stopWords");
        HashSet<String> stopWordsSet = null;
        if (stopWords != null && fields != null) {
            stopWordsSet = new HashSet<String>();
            for (String field : fields) {
                try (TokenStream ts = this.analyzer.tokenStream(field, stopWords);){
                    CharTermAttribute termAtt = ts.addAttribute(CharTermAttribute.class);
                    ts.reset();
                    while (ts.incrementToken()) {
                        stopWordsSet.add(termAtt.toString());
                    }
                    ts.end();
                }
                catch (IOException ioe) {
                    throw new ParserException("IoException parsing stop words list in " + this.getClass().getName() + ":" + ioe.getLocalizedMessage());
                }
            }
        }
        MoreLikeThisQuery mlt = new MoreLikeThisQuery(DOMUtils.getText(e), fields, this.analyzer, fields[0]);
        mlt.setMaxQueryTerms(DOMUtils.getAttribute(e, "maxQueryTerms", 20));
        mlt.setMinTermFrequency(DOMUtils.getAttribute(e, "minTermFrequency", 1));
        mlt.setPercentTermsToMatch(DOMUtils.getAttribute(e, "percentTermsToMatch", 30.0f) / 100.0f);
        mlt.setStopWords(stopWordsSet);
        int minDocFreq = DOMUtils.getAttribute(e, "minDocFreq", -1);
        if (minDocFreq >= 0) {
            mlt.setMinDocFreq(minDocFreq);
        }
        Query q = mlt;
        float boost = DOMUtils.getAttribute(e, "boost", 1.0f);
        if (boost != 1.0f) {
            q = new BoostQuery(mlt, boost);
        }
        return q;
    }
}

