/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.search.DisiPriorityQueue;
import guideme.internal.shaded.lucene.search.DisiWrapper;
import guideme.internal.shaded.lucene.search.DisjunctionDISIApproximation;
import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import guideme.internal.shaded.lucene.search.IndriScorer;
import guideme.internal.shaded.lucene.search.ScoreMode;
import guideme.internal.shaded.lucene.search.Scorer;
import java.io.IOException;
import java.util.List;

public abstract class IndriDisjunctionScorer
extends IndriScorer {
    private final List<Scorer> subScorersList;
    private final DisiPriorityQueue subScorers;
    private final DocIdSetIterator approximation;

    protected IndriDisjunctionScorer(List<Scorer> subScorersList, ScoreMode scoreMode, float boost) {
        super(boost);
        this.subScorersList = subScorersList;
        this.subScorers = new DisiPriorityQueue(subScorersList.size());
        for (Scorer scorer : subScorersList) {
            DisiWrapper w = new DisiWrapper(scorer, false);
            this.subScorers.add(w);
        }
        this.approximation = new DisjunctionDISIApproximation(this.subScorers);
    }

    @Override
    public DocIdSetIterator iterator() {
        return this.approximation;
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        return 0.0f;
    }

    public List<Scorer> getSubMatches() throws IOException {
        return this.subScorersList;
    }

    abstract float score(List<Scorer> var1) throws IOException;

    public abstract float smoothingScore(List<Scorer> var1, int var2) throws IOException;

    @Override
    public float score() throws IOException {
        return this.score(this.getSubMatches());
    }

    @Override
    public float smoothingScore(int docId) throws IOException {
        return this.smoothingScore(this.getSubMatches(), docId);
    }

    @Override
    public int docID() {
        return this.subScorers.top().doc;
    }
}

