/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.index.ByteVectorValues;
import guideme.internal.shaded.lucene.index.FieldInfo;
import guideme.internal.shaded.lucene.index.LeafReader;
import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.search.AbstractKnnVectorQuery;
import guideme.internal.shaded.lucene.search.KnnCollector;
import guideme.internal.shaded.lucene.search.Query;
import guideme.internal.shaded.lucene.search.TopDocs;
import guideme.internal.shaded.lucene.search.TopDocsCollector;
import guideme.internal.shaded.lucene.search.VectorScorer;
import guideme.internal.shaded.lucene.search.knn.KnnCollectorManager;
import guideme.internal.shaded.lucene.util.ArrayUtil;
import guideme.internal.shaded.lucene.util.Bits;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;

public class KnnByteVectorQuery
extends AbstractKnnVectorQuery {
    private static final TopDocs NO_RESULTS = TopDocsCollector.EMPTY_TOPDOCS;
    private final byte[] target;

    public KnnByteVectorQuery(String field, byte[] target, int k) {
        this(field, target, k, null);
    }

    public KnnByteVectorQuery(String field, byte[] target, int k, Query filter) {
        super(field, k, filter);
        this.target = Objects.requireNonNull(target, "target");
    }

    @Override
    protected TopDocs approximateSearch(LeafReaderContext context, Bits acceptDocs, int visitedLimit, KnnCollectorManager knnCollectorManager) throws IOException {
        KnnCollector knnCollector = knnCollectorManager.newCollector(visitedLimit, context);
        LeafReader reader = context.reader();
        ByteVectorValues byteVectorValues = reader.getByteVectorValues(this.field);
        if (byteVectorValues == null) {
            ByteVectorValues.checkField(reader, this.field);
            return NO_RESULTS;
        }
        if (Math.min(knnCollector.k(), byteVectorValues.size()) == 0) {
            return NO_RESULTS;
        }
        reader.searchNearestVectors(this.field, this.target, knnCollector, acceptDocs);
        TopDocs results = knnCollector.topDocs();
        return results != null ? results : NO_RESULTS;
    }

    @Override
    VectorScorer createVectorScorer(LeafReaderContext context, FieldInfo fi) throws IOException {
        LeafReader reader = context.reader();
        ByteVectorValues vectorValues = reader.getByteVectorValues(this.field);
        if (vectorValues == null) {
            ByteVectorValues.checkField(reader, this.field);
            return null;
        }
        return vectorValues.scorer(this.target);
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getSimpleName() + ":");
        buffer.append(this.field + "[" + this.target[0] + ",...]");
        buffer.append("[" + this.k + "]");
        if (this.filter != null) {
            buffer.append("[" + String.valueOf(this.filter) + "]");
        }
        return buffer.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        KnnByteVectorQuery that = (KnnByteVectorQuery)o;
        return Arrays.equals(this.target, that.target);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), Arrays.hashCode(this.target));
    }

    public byte[] getTargetCopy() {
        return ArrayUtil.copyArray(this.target);
    }
}

