/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search;

import guideme.internal.shaded.lucene.index.LeafReaderContext;
import guideme.internal.shaded.lucene.index.PostingsEnum;
import guideme.internal.shaded.lucene.index.Term;
import guideme.internal.shaded.lucene.index.TermStates;
import guideme.internal.shaded.lucene.index.Terms;
import guideme.internal.shaded.lucene.index.TermsEnum;
import guideme.internal.shaded.lucene.search.AbstractMultiTermQueryConstantScoreWrapper;
import guideme.internal.shaded.lucene.search.ConstantScoreQuery;
import guideme.internal.shaded.lucene.search.IndexSearcher;
import guideme.internal.shaded.lucene.search.MultiTermQuery;
import guideme.internal.shaded.lucene.search.ScoreMode;
import guideme.internal.shaded.lucene.search.TermQuery;
import guideme.internal.shaded.lucene.search.Weight;
import guideme.internal.shaded.lucene.util.DocIdSetBuilder;
import java.io.IOException;
import java.util.List;

final class MultiTermQueryConstantScoreWrapper<Q extends MultiTermQuery>
extends AbstractMultiTermQueryConstantScoreWrapper<Q> {
    MultiTermQueryConstantScoreWrapper(Q query) {
        super(query);
    }

    @Override
    public Weight createWeight(final IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new AbstractMultiTermQueryConstantScoreWrapper.RewritingWeight(this.query, boost, scoreMode, searcher){

            @Override
            protected AbstractMultiTermQueryConstantScoreWrapper.WeightOrDocIdSetIterator rewriteInner(LeafReaderContext context, int fieldDocCount, Terms terms, TermsEnum termsEnum, List<AbstractMultiTermQueryConstantScoreWrapper.TermAndState> collectedTerms) throws IOException {
                DocIdSetBuilder builder = new DocIdSetBuilder(context.reader().maxDoc(), terms);
                PostingsEnum docs = null;
                if (!collectedTerms.isEmpty()) {
                    TermsEnum termsEnum2 = terms.iterator();
                    for (AbstractMultiTermQueryConstantScoreWrapper.TermAndState t : collectedTerms) {
                        termsEnum2.seekExact(t.term, t.state);
                        docs = termsEnum2.postings(docs, 0);
                        builder.add(docs);
                    }
                }
                do {
                    docs = termsEnum.postings(docs, 0);
                    int docFreq = termsEnum.docFreq();
                    if (fieldDocCount == docFreq) {
                        TermStates termStates = new TermStates(searcher.getTopReaderContext());
                        termStates.register(termsEnum.termState(), context.ord, docFreq, termsEnum.totalTermFreq());
                        ConstantScoreQuery q = new ConstantScoreQuery(new TermQuery(new Term(MultiTermQueryConstantScoreWrapper.this.query.field, termsEnum.term()), termStates));
                        Weight weight = searcher.rewrite(q).createWeight(searcher, scoreMode, this.score());
                        return new AbstractMultiTermQueryConstantScoreWrapper.WeightOrDocIdSetIterator(weight);
                    }
                    builder.add(docs);
                } while (termsEnum.next() != null);
                return new AbstractMultiTermQueryConstantScoreWrapper.WeightOrDocIdSetIterator(builder.build().iterator());
            }
        };
    }
}

