/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.store;

import guideme.internal.shaded.lucene.store.IndexOutput;
import guideme.internal.shaded.lucene.util.BitUtil;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;

public class OutputStreamIndexOutput
extends IndexOutput {
    private final CRC32 crc = new CRC32();
    private final XBufferedOutputStream os;
    private long bytesWritten = 0L;
    private boolean flushedOnClose = false;

    public OutputStreamIndexOutput(String resourceDescription, String name, OutputStream out, int bufferSize) {
        super(resourceDescription, name);
        if (bufferSize < 8) {
            throw new IllegalArgumentException("Buffer size too small, need: 8");
        }
        this.os = new XBufferedOutputStream(new CheckedOutputStream(out, this.crc), bufferSize);
    }

    @Override
    public final void writeByte(byte b) throws IOException {
        this.os.write(b);
        ++this.bytesWritten;
    }

    @Override
    public final void writeBytes(byte[] b, int offset, int length) throws IOException {
        this.os.write(b, offset, length);
        this.bytesWritten += (long)length;
    }

    @Override
    public void writeShort(short i) throws IOException {
        this.os.writeShort(i);
        this.bytesWritten += 2L;
    }

    @Override
    public void writeInt(int i) throws IOException {
        this.os.writeInt(i);
        this.bytesWritten += 4L;
    }

    @Override
    public void writeLong(long i) throws IOException {
        this.os.writeLong(i);
        this.bytesWritten += 8L;
    }

    @Override
    public void close() throws IOException {
        try (XBufferedOutputStream o = this.os;){
            if (!this.flushedOnClose) {
                this.flushedOnClose = true;
                ((OutputStream)o).flush();
            }
        }
    }

    @Override
    public final long getFilePointer() {
        return this.bytesWritten;
    }

    @Override
    public final long getChecksum() throws IOException {
        this.os.flush();
        return this.crc.getValue();
    }

    private static final class XBufferedOutputStream
    extends BufferedOutputStream {
        XBufferedOutputStream(OutputStream out, int size) {
            super(out, size);
        }

        private void flushIfNeeded(int len) throws IOException {
            if (len > this.buf.length - this.count) {
                this.flush();
            }
        }

        void writeShort(short i) throws IOException {
            this.flushIfNeeded(2);
            BitUtil.VH_LE_SHORT.set(this.buf, this.count, i);
            this.count += 2;
        }

        void writeInt(int i) throws IOException {
            this.flushIfNeeded(4);
            BitUtil.VH_LE_INT.set(this.buf, this.count, i);
            this.count += 4;
        }

        void writeLong(long i) throws IOException {
            this.flushIfNeeded(8);
            BitUtil.VH_LE_LONG.set(this.buf, this.count, i);
            this.count += 8;
        }

        @Override
        public void write(int b) throws IOException {
            int count = this.count;
            byte[] buffer = this.buf;
            if (count >= buffer.length) {
                super.write(b);
            } else {
                buffer[count] = (byte)b;
                this.count = count + 1;
            }
        }
    }
}

