/*
 * Decompiled with CFR 0.152.
 */
package guideme.scene;

import guideme.compiler.PageCompiler;
import guideme.compiler.tags.BlockTagCompiler;
import guideme.compiler.tags.MdxAttrs;
import guideme.document.block.LytBlockContainer;
import guideme.libs.mdast.mdx.model.MdxJsxElementFields;
import guideme.libs.mdast.model.MdAstNode;
import guideme.scene.CameraSettings;
import guideme.scene.GuidebookScene;
import guideme.scene.LytGuidebookScene;
import guideme.scene.PerspectivePreset;
import guideme.scene.level.GuidebookLevel;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;

public class BlockImageTagCompiler
extends BlockTagCompiler {
    public static final String TAG_NAME = "BlockImage";

    @Override
    public Set<String> getTagNames() {
        return Set.of(TAG_NAME);
    }

    @Override
    protected void compile(PageCompiler compiler, LytBlockContainer parent, MdxJsxElementFields el) {
        Pair<ResourceLocation, Block> pair = MdxAttrs.getRequiredBlockAndId(compiler, parent, el, "id");
        if (pair == null) {
            return;
        }
        float scale = MdxAttrs.getFloat(compiler, parent, el, "scale", 1.0f);
        PerspectivePreset perspective = MdxAttrs.getEnum(compiler, parent, el, "perspective", PerspectivePreset.ISOMETRIC_NORTH_EAST);
        if (perspective == null) {
            return;
        }
        BlockState state = ((Block)pair.getRight()).defaultBlockState();
        state = MdxAttrs.applyBlockStateProperties(compiler, parent, el, state);
        GuidebookLevel level = new GuidebookLevel();
        CameraSettings cameraSettings = new CameraSettings();
        cameraSettings.setZoom(scale);
        cameraSettings.setPerspectivePreset(perspective);
        GuidebookScene scene = new GuidebookScene(level, cameraSettings);
        level.setBlockAndUpdate(BlockPos.ZERO, state);
        scene.centerScene();
        LytGuidebookScene lytScene = new LytGuidebookScene(compiler.getExtensions());
        lytScene.setScene(scene);
        lytScene.setInteractive(false);
        lytScene.setSourceNode((MdAstNode)((Object)el));
        parent.append(lytScene);
    }
}

