/*
 * Decompiled with CFR 0.152.
 */
package com.cwg.mod.gui;

import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.pokemon.evolution.Evolution;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.mod.common.util.ResourceLocationExtensionsKt;
import com.cwg.mod.CobblemonWikiGui;
import com.cwg.mod.config.CobblemonWikiGuiLang;
import com.cwg.mod.gui.PokeWikiGui;
import com.cwg.mod.helper.GuiHelper;
import com.cwg.mod.util.CobblemonUtil;
import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import eu.pb4.sgui.api.gui.SlotGuiInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.ResourceLocationException;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nR\u0017\u0010\f\u001a\u00020\u000b8\u0006\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/cwg/mod/gui/EvolutionsGui;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/pokemon/Species;", "species", "Lnet/minecraft/server/level/ServerPlayer;", "player", "Leu/pb4/sgui/api/gui/SimpleGui;", "open", "(Lcom/cobblemon/mod/common/pokemon/Species;Lnet/minecraft/server/level/ServerPlayer;)Leu/pb4/sgui/api/gui/SimpleGui;", "Lcom/cwg/mod/config/CobblemonWikiGuiLang;", "lang", "Lcom/cwg/mod/config/CobblemonWikiGuiLang;", "getLang", "()Lcom/cwg/mod/config/CobblemonWikiGuiLang;", "common"})
@SourceDebugExtension(value={"SMAP\nEvolutionsGui.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EvolutionsGui.kt\ncom/cwg/mod/gui/EvolutionsGui\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1863#2,2:106\n*S KotlinDebug\n*F\n+ 1 EvolutionsGui.kt\ncom/cwg/mod/gui/EvolutionsGui\n*L\n63#1:106,2\n*E\n"})
public final class EvolutionsGui {
    @NotNull
    public static final EvolutionsGui INSTANCE = new EvolutionsGui();
    @NotNull
    private static final CobblemonWikiGuiLang lang = CobblemonWikiGui.INSTANCE.getLangConfig();

    private EvolutionsGui() {
    }

    @NotNull
    public final CobblemonWikiGuiLang getLang() {
        return lang;
    }

    @NotNull
    public final SimpleGui open(@NotNull Species species, @NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)species, (String)"species");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        ArrayList<GuiElement> content = new ArrayList<GuiElement>();
        Integer[] integerArray = new Integer[]{0, 10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25};
        Integer[] CONTENT_SPACE = integerArray;
        SimpleGui gui = new SimpleGui(MenuType.GENERIC_9x4, player, false);
        GuiElement redPane = GuiHelper.INSTANCE.getRED_PANE();
        MutableComponent mutableComponent = Component.literal((String)"Cobblemon Wiki - Evolutions");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
        gui.setTitle((Component)TextKt.red((MutableComponent)mutableComponent));
        Set evolutions = species.getStandardForm().getEvolutions();
        if (evolutions.isEmpty()) {
            ItemStack itemStack = Items.PAPER.getDefaultInstance();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getDefaultInstance(...)");
            GuiElementBuilder guiElementBuilder = GuiHelper.INSTANCE.createEmptyButton(itemStack);
            String string = lang.getNoEvolutionFound();
            Object[] objectArray = new Object[]{species.getName()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            content.add(guiElementBuilder.setName((Component)TextKt.yellow((MutableComponent)TextKt.text((String)string2))).setLore(CollectionsKt.listOf((Object)TextKt.text((String)lang.getGoBackClick()))).setCallback((arg_0, arg_1, arg_2, arg_3) -> EvolutionsGui.open$lambda$1(species, arg_0, arg_1, arg_2, arg_3)).build());
        } else {
            ItemStack itemStack = Items.BARRIER.getDefaultInstance();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getDefaultInstance(...)");
            content.add(GuiHelper.INSTANCE.createEmptyButton(itemStack).setName((Component)TextKt.yellow((MutableComponent)TextKt.text((String)lang.getGoBackClick()))).setCallback((arg_0, arg_1, arg_2, arg_3) -> EvolutionsGui.open$lambda$3(species, arg_0, arg_1, arg_2, arg_3)).build());
            Iterable $this$forEach$iv = evolutions;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Species species2;
                Evolution it = (Evolution)element$iv;
                boolean bl = false;
                if (it.getResult().getSpecies() != null) {
                    Species species3;
                    boolean bl2 = false;
                    try {
                        String it2;
                        species3 = PokemonSpecies.INSTANCE.getByIdentifier(ResourceLocationExtensionsKt.asIdentifierDefaultingNamespace$default((String)it2, null, (int)1, null));
                    }
                    catch (ResourceLocationException e) {
                        species3 = null;
                    }
                    species2 = species3;
                } else {
                    species2 = null;
                }
                Species pokemonSpecies = species2;
                List<Component> loreRequirements = CobblemonUtil.INSTANCE.getRequirementsToWikiGui(it);
                if (pokemonSpecies == null) continue;
                GuiElement button = GuiHelper.INSTANCE.createPokemonButton(pokemonSpecies).setLore(loreRequirements).setCallback((arg_0, arg_1, arg_2, arg_3) -> EvolutionsGui.open$lambda$7$lambda$6(pokemonSpecies, arg_0, arg_1, arg_2, arg_3)).build();
                content.add(button);
            }
        }
        int n = ((Collection)content).size();
        for (int j = 0; j < n; ++j) {
            gui.setSlot(CONTENT_SPACE[j].intValue(), (GuiElementInterface)content.get(j));
        }
        n = gui.getSize();
        for (int i = 0; i < n; ++i) {
            if (gui.getSlot(i) != null) continue;
            gui.setSlot(i, (GuiElementInterface)redPane);
        }
        gui.open();
        return gui;
    }

    private static final void open$lambda$1(Species $species, int n, eu.pb4.sgui.api.ClickType clickType, ClickType clickType2, SlotGuiInterface gui) {
        Intrinsics.checkNotNullParameter((Object)$species, (String)"$species");
        EvolutionsGui $this$open_u24lambda_u241_u24lambda_u240 = INSTANCE;
        boolean bl = false;
        gui.close();
        ServerPlayer serverPlayer = gui.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)serverPlayer, (String)"getPlayer(...)");
        PokeWikiGui.INSTANCE.open($species, serverPlayer);
    }

    private static final void open$lambda$3(Species $species, int n, eu.pb4.sgui.api.ClickType clickType, ClickType clickType2, SlotGuiInterface gui) {
        Intrinsics.checkNotNullParameter((Object)$species, (String)"$species");
        EvolutionsGui $this$open_u24lambda_u243_u24lambda_u242 = INSTANCE;
        boolean bl = false;
        gui.close();
        ServerPlayer serverPlayer = gui.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)serverPlayer, (String)"getPlayer(...)");
        PokeWikiGui.INSTANCE.open($species, serverPlayer);
    }

    private static final void open$lambda$7$lambda$6(Species $pokemonSpecies, int n, eu.pb4.sgui.api.ClickType clickType, ClickType clickType2, SlotGuiInterface gui) {
        EvolutionsGui $this$open_u24lambda_u247_u24lambda_u246_u24lambda_u245 = INSTANCE;
        boolean bl = false;
        gui.close();
        ServerPlayer serverPlayer = gui.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)serverPlayer, (String)"getPlayer(...)");
        PokeWikiGui.INSTANCE.open($pokemonSpecies, serverPlayer);
    }
}

