/*
 * Decompiled with CFR 0.152.
 */
package com.cwg.mod.gui;

import com.cobblemon.mod.common.CobblemonItems;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.text.TextKt;
import com.cobblemon.mod.common.pokemon.Species;
import com.cwg.mod.CobblemonWikiGui;
import com.cwg.mod.config.CobblemonWikiGuiLang;
import com.cwg.mod.gui.EvolutionsGui;
import com.cwg.mod.helper.GuiHelper;
import com.cwg.mod.util.CobblemonUtil;
import eu.pb4.sgui.api.elements.GuiElement;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import eu.pb4.sgui.api.gui.SlotGuiInterface;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ'\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00112\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0016\u001a\u00020\u00158\u0006\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00128\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lcom/cwg/mod/gui/PokeWikiGui;", "", "<init>", "()V", "Lcom/cobblemon/mod/common/pokemon/Species;", "species", "Lnet/minecraft/server/level/ServerPlayer;", "playerEntity", "Leu/pb4/sgui/api/gui/SimpleGui;", "open", "(Lcom/cobblemon/mod/common/pokemon/Species;Lnet/minecraft/server/level/ServerPlayer;)Leu/pb4/sgui/api/gui/SimpleGui;", "", "step", "Leu/pb4/sgui/api/elements/GuiElementBuilder;", "createRelativeButton", "(Lcom/cobblemon/mod/common/pokemon/Species;I)Leu/pb4/sgui/api/elements/GuiElementBuilder;", "serverPlayerEntity", "", "Leu/pb4/sgui/api/elements/GuiElement;", "contentMain", "(Lcom/cobblemon/mod/common/pokemon/Species;Lnet/minecraft/server/level/ServerPlayer;)[Leu/pb4/sgui/api/elements/GuiElement;", "Lcom/cwg/mod/config/CobblemonWikiGuiLang;", "lang", "Lcom/cwg/mod/config/CobblemonWikiGuiLang;", "getLang", "()Lcom/cwg/mod/config/CobblemonWikiGuiLang;", "redPane", "Leu/pb4/sgui/api/elements/GuiElement;", "CONTENT_SPACE", "[Ljava/lang/Integer;", "MAX_CONTENT", "I", "common"})
public final class PokeWikiGui {
    @NotNull
    public static final PokeWikiGui INSTANCE = new PokeWikiGui();
    @NotNull
    private static final CobblemonWikiGuiLang lang = CobblemonWikiGui.INSTANCE.getLangConfig();
    @NotNull
    private static final GuiElement redPane = GuiHelper.INSTANCE.getRED_PANE();
    @NotNull
    private static final Integer[] CONTENT_SPACE;
    private static final int MAX_CONTENT;

    private PokeWikiGui() {
    }

    @NotNull
    public final CobblemonWikiGuiLang getLang() {
        return lang;
    }

    @NotNull
    public final SimpleGui open(@NotNull Species species, @NotNull ServerPlayer playerEntity) {
        Intrinsics.checkNotNullParameter((Object)species, (String)"species");
        Intrinsics.checkNotNullParameter((Object)playerEntity, (String)"playerEntity");
        GuiElement[] content = this.contentMain(species, playerEntity);
        if (content.length > MAX_CONTENT) {
            throw new RuntimeException("The content provided exceeds " + MAX_CONTENT + " elements or is invalid.");
        }
        SimpleGui gui = new SimpleGui(MenuType.GENERIC_9x6, playerEntity, false);
        MutableComponent mutableComponent = Component.literal((String)"Cobblemon Wiki");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
        gui.setTitle((Component)TextKt.red((MutableComponent)mutableComponent));
        GuiHelper.INSTANCE.setLine(GuiHelper.LineType.HORIZONTAL, gui, 0, 0, 8, redPane);
        GuiHelper.INSTANCE.setLine(GuiHelper.LineType.VERTICAL, gui, 0, 1, 3, redPane);
        GuiHelper.INSTANCE.setLine(GuiHelper.LineType.HORIZONTAL, gui, 4, 0, 8, redPane);
        gui.setSlot(48, (GuiElementInterface)this.createRelativeButton(species, -1).build());
        gui.setSlot(49, (GuiElementInterface)GuiHelper.INSTANCE.createPokemonButton(species).build());
        gui.setSlot(50, (GuiElementInterface)this.createRelativeButton(species, 1).build());
        GuiHelper.INSTANCE.setLine(GuiHelper.LineType.VERTICAL, gui, 8, 1, 3, redPane);
        GuiHelper.INSTANCE.setLine(GuiHelper.LineType.HORIZONTAL, gui, 5, 0, 2, redPane);
        GuiHelper.INSTANCE.setLine(GuiHelper.LineType.HORIZONTAL, gui, 5, 6, 8, redPane);
        int n = content.length;
        for (int j = 0; j < n; ++j) {
            gui.setSlot(CONTENT_SPACE[j].intValue(), (GuiElementInterface)content[j]);
        }
        n = gui.getSize();
        for (int i = 0; i < n; ++i) {
            if (gui.getSlot(i) != null) continue;
            gui.setSlot(i, (GuiElementInterface)redPane);
        }
        gui.open();
        return gui;
    }

    private final GuiElementBuilder createRelativeButton(Species species, int step) {
        Species relative = PokemonSpecies.getByPokedexNumber$default((PokemonSpecies)PokemonSpecies.INSTANCE, (int)(species.getNationalPokedexNumber() + step), null, (int)2, null);
        if (relative != null) {
            GuiElementBuilder guiElementBuilder = GuiHelper.INSTANCE.createPokemonButton(relative).setLore(CollectionsKt.listOf((Object)TextKt.text((String)lang.getPokeInfo()))).setCallback((arg_0, arg_1, arg_2, arg_3) -> PokeWikiGui.createRelativeButton$lambda$1(relative, arg_0, arg_1, arg_2, arg_3));
            Intrinsics.checkNotNullExpressionValue((Object)guiElementBuilder, (String)"setCallback(...)");
            return guiElementBuilder;
        }
        ItemStack itemStack = redPane.getItemStack();
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemStack(...)");
        return GuiHelper.INSTANCE.createEmptyButton(itemStack);
    }

    private final GuiElement[] contentMain(Species species, ServerPlayer serverPlayerEntity) {
        GuiElement[] guiElementArray = new GuiElement[18];
        guiElementArray[0] = GuiHelper.INSTANCE.createEmptyButton(new ItemStack((ItemLike)CobblemonItems.LIGHT_BALL)).setName((Component)TextKt.text((String)lang.getType())).setLore(CollectionsKt.toMutableList((Collection)CobblemonUtil.INSTANCE.getTypeToWikiGui(species))).build();
        guiElementArray[1] = GuiHelper.INSTANCE.createEmptyButton(new ItemStack((ItemLike)CobblemonItems.ELECTIRIZER)).setName((Component)TextKt.text((String)lang.getEffectiveness())).setLore(CobblemonUtil.INSTANCE.getEffectiveness(species)).build();
        guiElementArray[2] = GuiHelper.INSTANCE.createEmptyButton(new ItemStack((ItemLike)CobblemonItems.POKE_BALL)).setName((Component)TextKt.text((String)lang.getCatchrate())).setLore(CobblemonUtil.INSTANCE.getCatchRateToWikiGui(species)).build();
        guiElementArray[3] = GuiHelper.INSTANCE.createEmptyButton(new ItemStack((ItemLike)CobblemonItems.WEAKNESS_POLICY)).setName((Component)TextKt.text((String)lang.getBasestats())).setLore(CobblemonUtil.INSTANCE.getBaseStatsToWikiGui(species)).build();
        GuiElementBuilder guiElementBuilder = GuiHelper.INSTANCE.createEmptyButton(new ItemStack((ItemLike)Items.OAK_SAPLING)).setName((Component)TextKt.text((String)lang.getSpawnbiome()));
        ServerLevel serverLevel = serverPlayerEntity.serverLevel();
        Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"serverLevel(...)");
        guiElementArray[4] = guiElementBuilder.setLore(CobblemonUtil.INSTANCE.getSpawnBiomesToWikiGui(species, (Level)serverLevel)).build();
        guiElementArray[5] = GuiHelper.INSTANCE.createPokemonButton(species).setName((Component)TextKt.text((String)lang.getEvolutions())).setLore(CollectionsKt.listOf((Object)TextKt.text((String)lang.getSeeEvolutions()))).setCallback((arg_0, arg_1, arg_2, arg_3) -> PokeWikiGui.contentMain$lambda$2(species, serverPlayerEntity, arg_0, arg_1, arg_2, arg_3)).build();
        guiElementArray[6] = GuiHelper.INSTANCE.createEmptyButton(new ItemStack((ItemLike)Items.CLOCK)).setName((Component)Component.literal((String)lang.getSpawntime())).setLore(CobblemonUtil.INSTANCE.getSpawnTime(species)).build();
        guiElementArray[7] = GuiHelper.INSTANCE.createEmptyButton(new ItemStack((ItemLike)CobblemonItems.ABILITY_CAPSULE)).setName((Component)Component.literal((String)lang.getAbilities())).setLore(CobblemonUtil.INSTANCE.getAbilities(species)).build();
        guiElementArray[8] = GuiHelper.INSTANCE.createEmptyButton(new ItemStack((ItemLike)CobblemonItems.LEVEL_BALL)).setName((Component)Component.literal((String)lang.getMovesbylevel())).setLore(CobblemonUtil.INSTANCE.getMovesByLevelToWikiGui(species)).build();
        guiElementArray[9] = GuiHelper.INSTANCE.createEmptyButton(new ItemStack((ItemLike)CobblemonItems.LIGHT_BALL)).setName((Component)Component.literal((String)lang.getTmMoves())).setLore(CobblemonUtil.INSTANCE.getTmMoves(species)).build();
        guiElementArray[10] = GuiHelper.INSTANCE.createEmptyButton(new ItemStack((ItemLike)CobblemonItems.FRIEND_BALL)).setName((Component)Component.literal((String)lang.getTutorMoves())).setLore(CobblemonUtil.INSTANCE.getTutorMoves(species)).build();
        guiElementArray[11] = GuiHelper.INSTANCE.createEmptyButton(new ItemStack((ItemLike)CobblemonItems.ULTRA_BALL)).setName((Component)Component.literal((String)lang.getEvolutionMoves())).setLore(CobblemonUtil.INSTANCE.getEvolutionMoves(species)).build();
        guiElementArray[12] = GuiHelper.INSTANCE.createEmptyButton(new ItemStack((ItemLike)CobblemonItems.POWER_WEIGHT)).setName((Component)Component.literal((String)lang.getFormChangeMoves())).setLore(CobblemonUtil.INSTANCE.getFormChangeMoves(species)).build();
        guiElementArray[13] = GuiHelper.INSTANCE.createEmptyButton(new ItemStack((ItemLike)CobblemonItems.OVAL_STONE)).setName((Component)Component.literal((String)lang.getEggMoves())).setLore(CobblemonUtil.INSTANCE.getEggMoves(species)).build();
        guiElementArray[14] = GuiHelper.INSTANCE.createEmptyButton(new ItemStack((ItemLike)CobblemonItems.LUCKY_EGG)).setName((Component)Component.literal((String)lang.getEggGroups())).setLore(CobblemonUtil.INSTANCE.getEggGroups(species)).build();
        guiElementArray[15] = GuiHelper.INSTANCE.createEmptyButton(new ItemStack((ItemLike)CobblemonItems.NORMAL_GEM)).setName((Component)Component.literal((String)lang.getForms())).setLore(CobblemonUtil.INSTANCE.getForms(species)).build();
        guiElementArray[16] = GuiHelper.INSTANCE.createEmptyButton(new ItemStack((ItemLike)CobblemonItems.AIR_BALLOON)).setName((Component)Component.literal((String)lang.getDynamax())).setLore(CobblemonUtil.INSTANCE.getDynamax(species)).build();
        guiElementArray[17] = GuiHelper.INSTANCE.createEmptyButton(new ItemStack((ItemLike)Items.BONE)).setName((Component)Component.literal((String)lang.getDrops())).setLore(CobblemonUtil.INSTANCE.getDrops(species)).build();
        GuiElement[] content = guiElementArray;
        return content;
    }

    private static final void createRelativeButton$lambda$1(Species $relative, int n, eu.pb4.sgui.api.ClickType clickType, ClickType clickType2, SlotGuiInterface gui) {
        PokeWikiGui $this$createRelativeButton_u24lambda_u241_u24lambda_u240 = INSTANCE;
        boolean bl = false;
        gui.close();
        ServerPlayer serverPlayer = gui.getPlayer();
        Intrinsics.checkNotNullExpressionValue((Object)serverPlayer, (String)"getPlayer(...)");
        $this$createRelativeButton_u24lambda_u241_u24lambda_u240.open($relative, serverPlayer);
    }

    private static final void contentMain$lambda$2(Species $species, ServerPlayer $serverPlayerEntity, int n, eu.pb4.sgui.api.ClickType clickType, ClickType clickType2, SlotGuiInterface gui) {
        Intrinsics.checkNotNullParameter((Object)$species, (String)"$species");
        Intrinsics.checkNotNullParameter((Object)$serverPlayerEntity, (String)"$serverPlayerEntity");
        gui.close();
        EvolutionsGui.INSTANCE.open($species, $serverPlayerEntity);
    }

    static {
        Integer[] integerArray = new Integer[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34};
        CONTENT_SPACE = integerArray;
        MAX_CONTENT = CONTENT_SPACE.length;
    }
}

