/*
 * Decompiled with CFR 0.152.
 */
package com.cwg.mod.neoforge.permission;

import com.cwg.mod.CobblemonWikiGui;
import com.cwg.mod.api.permission.CobblemonWikiGuiPermissions;
import com.cwg.mod.api.permission.Permission;
import com.cwg.mod.api.permission.PermissionValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.server.permission.PermissionAPI;
import net.neoforged.neoforge.server.permission.events.PermissionGatherEvent;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContext;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContextKey;
import net.neoforged.neoforge.server.permission.nodes.PermissionNode;
import net.neoforged.neoforge.server.permission.nodes.PermissionTypes;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0003J\u001f\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000b\u0010\u0010J\u001f\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\u0013J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000b\u0010\u0014J#\u0010\u0018\u001a\u0016\u0012\u0012\u0012\u0010\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\n0\n0\u00160\u0015H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u00162\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0019\u0010\u001c\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dR&\u0010 \u001a\u0014\u0012\u0004\u0012\u00020\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00160\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!\u00a8\u0006\""}, d2={"Lcom/cwg/mod/neoforge/permission/ForgePermissionValidator;", "Lcom/cwg/mod/api/permission/PermissionValidator;", "<init>", "()V", "", "initialize", "Lnet/minecraft/server/level/ServerPlayer;", "player", "Lcom/cwg/mod/api/permission/Permission;", "permission", "", "hasPermission", "(Lnet/minecraft/server/level/ServerPlayer;Lcom/cwg/mod/api/permission/Permission;)Z", "", "", "level", "(Lnet/minecraft/server/level/ServerPlayer;Ljava/lang/String;I)Z", "Lnet/minecraft/commands/CommandSourceStack;", "source", "(Lnet/minecraft/commands/CommandSourceStack;Lcom/cwg/mod/api/permission/Permission;)Z", "(Lnet/minecraft/commands/CommandSourceStack;Ljava/lang/String;I)Z", "", "Lnet/neoforged/neoforge/server/permission/nodes/PermissionNode;", "kotlin.jvm.PlatformType", "createNodes", "()Ljava/util/List;", "findNode", "(Lcom/cwg/mod/api/permission/Permission;)Lnet/neoforged/neoforge/server/permission/nodes/PermissionNode;", "extractPlayerFromSource", "(Lnet/minecraft/commands/CommandSourceStack;)Lnet/minecraft/server/level/ServerPlayer;", "Ljava/util/HashMap;", "Lnet/minecraft/resources/ResourceLocation;", "nodes", "Ljava/util/HashMap;", "neoforge"})
@SourceDebugExtension(value={"SMAP\nForgePermissionValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ForgePermissionValidator.kt\ncom/cwg/mod/neoforge/permission/ForgePermissionValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n1557#2:67\n1628#2,3:68\n*S KotlinDebug\n*F\n+ 1 ForgePermissionValidator.kt\ncom/cwg/mod/neoforge/permission/ForgePermissionValidator\n*L\n55#1:67\n55#1:68,3\n*E\n"})
public final class ForgePermissionValidator
implements PermissionValidator {
    @NotNull
    public static final ForgePermissionValidator INSTANCE = new ForgePermissionValidator();
    @NotNull
    private static final HashMap<ResourceLocation, PermissionNode<Boolean>> nodes = new HashMap();

    private ForgePermissionValidator() {
    }

    @Override
    public void initialize() {
        CobblemonWikiGui.LOGGER.info("Booting ForgePermissionApiPermissionValidator, player permissions will be checked using MinecraftForge' PermissionAPI, non player command sources will use Minecraft' permission level system, see https://docs.minecraftforge.net/en/latest/ and https://minecraft.fandom.com/wiki/Permission_level");
    }

    @Override
    public boolean hasPermission(@NotNull ServerPlayer player, @NotNull Permission permission) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        PermissionNode<Boolean> permissionNode = this.findNode(permission);
        if (permissionNode == null) {
            return player.hasPermissions(permission.getLevel().getNumericalValue());
        }
        PermissionNode<Boolean> node = permissionNode;
        Object object = PermissionAPI.getPermission((ServerPlayer)player, node, (PermissionDynamicContext[])new PermissionDynamicContext[0]);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getPermission(...)");
        return (Boolean)object;
    }

    @Override
    public boolean hasPermission(@NotNull ServerPlayer player, @NotNull String permission, int level) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        String[] stringArray = new String[]{"."};
        PermissionNode node = new PermissionNode((String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)permission, (String[])stringArray, (boolean)false, (int)0, (int)6, null)), StringsKt.substringAfter$default((String)permission, (String)".", null, (int)2, null), PermissionTypes.BOOLEAN, (arg_0, arg_1, arg_2) -> ForgePermissionValidator.hasPermission$lambda$1(level, arg_0, arg_1, arg_2), new PermissionDynamicContextKey[0]);
        Object object = PermissionAPI.getPermission((ServerPlayer)player, (PermissionNode)node, (PermissionDynamicContext[])new PermissionDynamicContext[0]);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getPermission(...)");
        return (Boolean)object;
    }

    @Override
    public boolean hasPermission(@NotNull CommandSourceStack source, @NotNull Permission permission) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        ServerPlayer serverPlayer = this.extractPlayerFromSource(source);
        if (serverPlayer == null) {
            return source.hasPermission(permission.getLevel().getNumericalValue());
        }
        ServerPlayer player = serverPlayer;
        PermissionNode<Boolean> permissionNode = this.findNode(permission);
        if (permissionNode == null) {
            return source.hasPermission(permission.getLevel().getNumericalValue());
        }
        PermissionNode<Boolean> node = permissionNode;
        Object object = PermissionAPI.getPermission((ServerPlayer)player, node, (PermissionDynamicContext[])new PermissionDynamicContext[0]);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getPermission(...)");
        return (Boolean)object;
    }

    @Override
    public boolean hasPermission(@NotNull CommandSourceStack source, @NotNull String permission, int level) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        ServerPlayer serverPlayer = this.extractPlayerFromSource(source);
        if (serverPlayer == null) {
            return source.hasPermission(4);
        }
        ServerPlayer player = serverPlayer;
        String[] stringArray = new String[]{"."};
        PermissionNode node = new PermissionNode((String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)permission, (String[])stringArray, (boolean)false, (int)0, (int)6, null)), StringsKt.substringAfter$default((String)permission, (String)".", null, (int)2, null), PermissionTypes.BOOLEAN, (arg_0, arg_1, arg_2) -> ForgePermissionValidator.hasPermission$lambda$2(level, arg_0, arg_1, arg_2), new PermissionDynamicContextKey[0]);
        Object object = PermissionAPI.getPermission((ServerPlayer)player, (PermissionNode)node, (PermissionDynamicContext[])new PermissionDynamicContext[0]);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getPermission(...)");
        return (Boolean)object;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PermissionNode<Boolean>> createNodes() {
        void $this$mapTo$iv$iv;
        Iterable<Permission> $this$map$iv = CobblemonWikiGuiPermissions.INSTANCE.all();
        boolean $i$f$map = false;
        Iterable<Permission> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void permission;
            Permission permission2 = (Permission)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            PermissionNode node = new PermissionNode(permission.getIdentifier(), PermissionTypes.BOOLEAN, (arg_0, arg_1, arg_2) -> ForgePermissionValidator.createNodes$lambda$4$lambda$3((Permission)permission, arg_0, arg_1, arg_2), new PermissionDynamicContextKey[0]);
            ((Map)nodes).put(permission.getIdentifier(), node);
            collection.add(node);
        }
        return (List)destination$iv$iv;
    }

    private final PermissionNode<Boolean> findNode(Permission permission) {
        return nodes.get(permission.getIdentifier());
    }

    private final ServerPlayer extractPlayerFromSource(CommandSourceStack source) {
        return source.getPlayer();
    }

    private static final void _init_$lambda$0(PermissionGatherEvent.Nodes event) {
        CobblemonWikiGui.LOGGER.info("Starting Forge permission node registry");
        event.addNodes((Iterable)INSTANCE.createNodes());
        CobblemonWikiGui.LOGGER.debug("Finished Forge permission node registry");
    }

    private static final Boolean hasPermission$lambda$1(int $level, ServerPlayer player, UUID uUID, PermissionDynamicContext[] permissionDynamicContextArray) {
        ServerPlayer serverPlayer = player;
        return serverPlayer != null ? serverPlayer.hasPermissions($level) : false;
    }

    private static final Boolean hasPermission$lambda$2(int $level, ServerPlayer player, UUID uUID, PermissionDynamicContext[] permissionDynamicContextArray) {
        ServerPlayer serverPlayer = player;
        return serverPlayer != null ? serverPlayer.hasPermissions($level) : false;
    }

    private static final Boolean createNodes$lambda$4$lambda$3(Permission $permission, ServerPlayer player, UUID uUID, PermissionDynamicContext[] permissionDynamicContextArray) {
        Intrinsics.checkNotNullParameter((Object)$permission, (String)"$permission");
        ServerPlayer serverPlayer = player;
        return serverPlayer != null ? serverPlayer.hasPermissions($permission.getLevel().getNumericalValue()) : false;
    }

    static {
        NeoForge.EVENT_BUS.addListener(ForgePermissionValidator::_init_$lambda$0);
    }
}

