/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.herbalbrews.core.effects;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class FeralEffect
extends MobEffect {
    public FeralEffect() {
        super(MobEffectCategory.BENEFICIAL, 65280);
        this.addAttributeModifier(Attributes.ATTACK_DAMAGE, ResourceLocation.withDefaultNamespace((String)"effect.strength"), 3.0, AttributeModifier.Operation.ADD_VALUE);
        this.addAttributeModifier(Attributes.MAX_HEALTH, ResourceLocation.withDefaultNamespace((String)"effect.health_boost"), 4.0, AttributeModifier.Operation.ADD_VALUE);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        Player player;
        if (entity instanceof Player && (player = (Player)entity).isAlive()) {
            int finalAmplifier;
            Level world = player.level();
            double radius = 10.0;
            List nearbyPlayers = world.getEntitiesOfClass(Player.class, player.getBoundingBox().inflate(radius));
            int playerCount = nearbyPlayers.size() - 1;
            if (playerCount < 0) {
                playerCount = 0;
            }
            if ((finalAmplifier = this.calculateFinalAmplifier(playerCount)) > 0) {
                this.addAttributeModifiers(entity.getAttributes(), finalAmplifier);
            }
        }
        return super.applyEffectTick(entity, amplifier);
    }

    private int calculateFinalAmplifier(int playerCount) {
        float baseAmplifier = 1.0f;
        float reductionPerPlayer = 0.1f;
        float calculatedAmplifier = baseAmplifier - (float)playerCount * reductionPerPlayer;
        if (calculatedAmplifier < 0.0f) {
            calculatedAmplifier = 0.0f;
        }
        int finalAmplifier = Math.round(calculatedAmplifier);
        return Math.max(0, Math.min(finalAmplifier, 3));
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int j) {
        return true;
    }
}

