/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.herbalbrews.core.items;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.satisfy.herbalbrews.platform.PlatformHelper;
import org.jetbrains.annotations.NotNull;

public class HatItem
extends ArmorItem {
    private final ResourceLocation hatTexture;

    public HatItem(Holder<ArmorMaterial> holder, ArmorItem.Type type, Item.Properties properties, ResourceLocation hatTexture) {
        super(holder, type, properties);
        this.hatTexture = hatTexture;
    }

    public ResourceLocation getHatTexture() {
        return this.hatTexture;
    }

    @NotNull
    public EquipmentSlot getEquipmentSlot() {
        return this.type.getSlot();
    }

    public static void applyMagicResistance(LivingEntity entity, float damageAmount, boolean isMagic) {
        Player player;
        ItemStack helmet;
        if (entity instanceof Player && (helmet = (player = (Player)entity).getItemBySlot(EquipmentSlot.HEAD)).getItem() instanceof HatItem && isMagic && PlatformHelper.isHatDamageReductionEnabled()) {
            float reduction = (float)PlatformHelper.getHatDamageReductionAmount() / 100.0f;
            float reducedDamage = damageAmount * (1.0f - reduction);
            entity.setHealth(entity.getHealth() + (damageAmount - reducedDamage));
        }
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        if (PlatformHelper.isHatDamageReductionEnabled()) {
            int reductionAmount = PlatformHelper.getHatDamageReductionAmount();
            MutableComponent magicDamage = Component.translatable((String)"tooltip.herbalbrews.magic_damage").setStyle(Style.EMPTY.withColor((TextColor)TextColor.parseColor((String)"#AA00FF").getOrThrow()));
            MutableComponent damageReduction = Component.translatable((String)"tooltip.herbalbrews.damage_reduction", (Object[])new Object[]{magicDamage, reductionAmount + "%"});
            tooltip.add((Component)damageReduction);
        }
    }
}

