/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.herbalbrews.core.registry;

import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.satisfy.herbalbrews.core.effects.BalancedEffect;
import net.satisfy.herbalbrews.core.effects.BondingEffect;
import net.satisfy.herbalbrews.core.effects.DeeprushEffect;
import net.satisfy.herbalbrews.core.effects.FeralEffect;
import net.satisfy.herbalbrews.core.effects.FortuneEffect;
import net.satisfy.herbalbrews.core.effects.LifeleechEffect;
import net.satisfy.herbalbrews.core.effects.ToughEffect;
import net.satisfy.herbalbrews.core.util.HerbalBrewsIdentifier;

public class EffectRegistry {
    private static final DeferredRegister<MobEffect> MOB_EFFECTS = DeferredRegister.create((String)"herbalbrews", (ResourceKey)Registries.MOB_EFFECT);
    private static final Registrar<MobEffect> MOB_EFFECTS_REGISTRAR = MOB_EFFECTS.getRegistrar();
    public static final RegistrySupplier<MobEffect> DEEPRUSH = EffectRegistry.registerEffect("deeprush", DeeprushEffect::new);
    public static final RegistrySupplier<MobEffect> BONDING;
    public static final RegistrySupplier<MobEffect> FORTUNE;
    public static final RegistrySupplier<MobEffect> BALANCED;
    public static final RegistrySupplier<MobEffect> FERAL;
    public static final RegistrySupplier<MobEffect> LIFELEECH;
    public static final RegistrySupplier<MobEffect> TOUGH;

    private static RegistrySupplier<MobEffect> registerEffect(String name, Supplier<MobEffect> effect) {
        if (Platform.isNeoForge()) {
            return MOB_EFFECTS.register(name, effect);
        }
        return MOB_EFFECTS_REGISTRAR.register(HerbalBrewsIdentifier.identifier(name), effect);
    }

    public static void init() {
        MOB_EFFECTS.register();
    }

    static {
        FORTUNE = EffectRegistry.registerEffect("fortune", FortuneEffect::new);
        BALANCED = EffectRegistry.registerEffect("balanced", BalancedEffect::new);
        LIFELEECH = EffectRegistry.registerEffect("lifeleech", LifeleechEffect::new);
        BONDING = EffectRegistry.registerEffect("bonding", BondingEffect::new);
        FERAL = EffectRegistry.registerEffect("feral", FeralEffect::new);
        TOUGH = EffectRegistry.registerEffect("tough", ToughEffect::new);
    }
}

