/*
 * Decompiled with CFR 0.152.
 */
package net.unusual.blockfactorysbosses;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.unusual.blockfactorysbosses.DragonTowerStructure;
import net.unusual.blockfactorysbosses.init.BlockFactorysBossesModAttributes;
import net.unusual.blockfactorysbosses.init.BlockFactorysBossesModBlockEntities;
import net.unusual.blockfactorysbosses.init.BlockFactorysBossesModBlocks;
import net.unusual.blockfactorysbosses.init.BlockFactorysBossesModEntities;
import net.unusual.blockfactorysbosses.init.BlockFactorysBossesModItems;
import net.unusual.blockfactorysbosses.init.BlockFactorysBossesModParticleTypes;
import net.unusual.blockfactorysbosses.init.BlockFactorysBossesModSounds;
import net.unusual.blockfactorysbosses.init.BlockFactorysBossesModTabs;
import net.unusual.blockfactorysbosses.network.BlockFactorysBossesModVariables;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="block_factorys_bosses")
public class BlockFactorysBossesMod {
    public static final Logger LOGGER = LogManager.getLogger(BlockFactorysBossesMod.class);
    public static final String MODID = "block_factorys_bosses";
    public static final DeferredRegister<StructureType<?>> STRUCTURE_TYPES = DeferredRegister.create((ResourceKey)Registries.STRUCTURE_TYPE, (String)"block_factorys_bosses");
    public static final DeferredHolder<StructureType<?>, StructureType<DragonTowerStructure>> DRAGON_TOWER = STRUCTURE_TYPES.register("dragon_tower", () -> () -> DragonTowerStructure.CODEC);
    private static boolean networkingRegistered = false;
    private static final Map<CustomPacketPayload.Type<?>, NetworkMessage<?>> MESSAGES = new HashMap();
    private static final Collection<Tuple<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<Tuple<Runnable, Integer>>();

    public BlockFactorysBossesMod(IEventBus modEventBus) {
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::registerNetworking);
        BlockFactorysBossesModSounds.REGISTRY.register(modEventBus);
        BlockFactorysBossesModBlocks.REGISTRY.register(modEventBus);
        BlockFactorysBossesModBlockEntities.REGISTRY.register(modEventBus);
        BlockFactorysBossesModItems.REGISTRY.register(modEventBus);
        BlockFactorysBossesModEntities.REGISTRY.register(modEventBus);
        BlockFactorysBossesModTabs.REGISTRY.register(modEventBus);
        BlockFactorysBossesModVariables.ATTACHMENT_TYPES.register(modEventBus);
        BlockFactorysBossesModParticleTypes.REGISTRY.register(modEventBus);
        BlockFactorysBossesModAttributes.REGISTRY.register(modEventBus);
        STRUCTURE_TYPES.register(modEventBus);
    }

    public static <T extends CustomPacketPayload> void addNetworkMessage(CustomPacketPayload.Type<T> id, StreamCodec<? extends FriendlyByteBuf, T> reader, IPayloadHandler<T> handler) {
        if (networkingRegistered) {
            throw new IllegalStateException("Cannot register new network messages after networking has been registered");
        }
        MESSAGES.put(id, new NetworkMessage<T>(reader, handler));
    }

    private void registerNetworking(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MODID);
        MESSAGES.forEach((id, networkMessage) -> registrar.playBidirectional(id, networkMessage.reader(), networkMessage.handler()));
        networkingRegistered = true;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add((Tuple<Runnable, Integer>)new Tuple((Object)action, (Object)tick));
        }
    }

    @SubscribeEvent
    public void tick(ServerTickEvent.Post event) {
        ArrayList actions = new ArrayList();
        workQueue.forEach(work -> {
            work.setB((Object)((Integer)work.getB() - 1));
            if ((Integer)work.getB() == 0) {
                actions.add(work);
            }
        });
        actions.forEach(e -> ((Runnable)e.getA()).run());
        workQueue.removeAll(actions);
    }

    private record NetworkMessage<T extends CustomPacketPayload>(StreamCodec<? extends FriendlyByteBuf, T> reader, IPayloadHandler<T> handler) {
    }
}

