/*
 * Decompiled with CFR 0.152.
 */
package net.unusual.blockfactorysbosses;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.unusual.blockfactorysbosses.AnimationTickHolder;
import net.unusual.blockfactorysbosses.client.model.Modelsandworm_dart;
import net.unusual.blockfactorysbosses.init.BlockFactorysBossesModItems;
import net.unusual.blockfactorysbosses.item.SandwormDartItem;

@OnlyIn(value=Dist.CLIENT)
public class SandwormDartItemRenderer
extends BlockEntityWithoutLevelRenderer {
    private final EntityModelSet entityModelSet;
    private final ItemStack transformSource;

    public SandwormDartItemRenderer(BlockEntityRenderDispatcher blockEntityRenderDispatcher, EntityModelSet entityModelSet) {
        super(blockEntityRenderDispatcher, entityModelSet);
        this.entityModelSet = entityModelSet;
        this.transformSource = new ItemStack((ItemLike)BlockFactorysBossesModItems.SANDWORM_DART.get());
    }

    public void renderByItem(ItemStack itemstack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Modelsandworm_dart model = new Modelsandworm_dart(this.entityModelSet.bakeLayer(Modelsandworm_dart.LAYER_LOCATION));
        if (model == null) {
            return;
        }
        if (displayContext != ItemDisplayContext.GUI) {
            float tick = AnimationTickHolder.getRenderTime();
            poseStack.pushPose();
            Minecraft.getInstance().getItemRenderer().getModel(this.transformSource, null, null, 0).applyTransform(displayContext, poseStack, SandwormDartItemRenderer.isLeftHand(displayContext));
            poseStack.translate(0.5, 1.55, 0.6);
            poseStack.scale(1.05f, 1.05f, 1.05f);
            poseStack.scale(1.0f, -1.0f, displayContext == ItemDisplayContext.GUI ? -1.0f : 1.0f);
            if (displayContext.firstPerson()) {
                poseStack.scale(1.1f, 1.1f, 1.1f);
                poseStack.mulPose(Axis.XP.rotationDegrees(-22.5f));
                if (displayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
                    poseStack.translate(0.5, 0.4, -0.2);
                }
                if (displayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND) {
                    poseStack.translate(-0.5, 0.4, -0.2);
                }
            } else {
                poseStack.translate(0.0, 0.05, 0.3);
                if (SandwormDartItemRenderer.isLeftHand(displayContext)) {
                    poseStack.scale(-1.0f, 1.0f, 1.0f);
                }
            }
            String key = ((CustomData)itemstack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getString("itemKey");
            AnimationState idleState = SandwormDartItem.IDLE_STATES.computeIfAbsent(key, s -> new AnimationState());
            AnimationState swingState = SandwormDartItem.SWING_STATES.computeIfAbsent(key, s -> new AnimationState());
            AnimationState suckState = SandwormDartItem.SUCK_STATES.computeIfAbsent(key, s -> new AnimationState());
            double swing_animtime = ((CustomData)itemstack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("swing_animtime");
            double suck_animtime = ((CustomData)itemstack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("suck_animtime");
            idleState.animateWhen(swing_animtime == 0.0 && suck_animtime == 0.0, Math.round(tick));
            swingState.animateWhen(swing_animtime > 0.0, Math.round(tick));
            suckState.animateWhen(suck_animtime > 0.0, Math.round(tick));
            int firstPersonContext = 0;
            if (displayContext.firstPerson()) {
                if (displayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
                    firstPersonContext = 1;
                }
                if (displayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND) {
                    firstPersonContext = 2;
                }
            }
            model.setupItemAnim(key, firstPersonContext, tick);
            VertexConsumer vertexConsumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)bufferSource, (RenderType)model.renderType(ResourceLocation.parse((String)"block_factorys_bosses:textures/entities/sandworm_dart.png")), (boolean)false, (boolean)itemstack.hasFoil());
            model.renderToBuffer(poseStack, vertexConsumer, packedLight, packedOverlay);
            poseStack.popPose();
        }
    }

    private static boolean isLeftHand(ItemDisplayContext type) {
        return type == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || type == ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
    }

    private static boolean isInventory(ItemDisplayContext type) {
        return type == ItemDisplayContext.GUI || type == ItemDisplayContext.FIXED;
    }
}

