/*
 * Decompiled with CFR 0.152.
 */
package net.unusual.blockfactorysbosses.block;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.unusual.blockfactorysbosses.procedures.WallTorchBlockValidPlacementConditionProcedure;
import net.unusual.blockfactorysbosses.procedures.WallTorchOnRandomClientDisplayTickProcedure;

public class WallTorchBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;

    public WallTorchBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(0.3f, 10.0f).lightLevel(s -> 15).noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> Shapes.or((VoxelShape)WallTorchBlock.box((double)7.0, (double)-3.5, (double)3.0, (double)9.0, (double)9.5, (double)5.0), (VoxelShape[])new VoxelShape[]{WallTorchBlock.box((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)6.0, (double)2.0), WallTorchBlock.box((double)6.5, (double)-0.5, (double)2.5, (double)9.5, (double)3.5, (double)5.5), WallTorchBlock.box((double)6.0, (double)5.5, (double)2.0, (double)10.0, (double)9.5, (double)6.0)});
            case Direction.NORTH -> Shapes.or((VoxelShape)WallTorchBlock.box((double)7.0, (double)-3.5, (double)11.0, (double)9.0, (double)9.5, (double)13.0), (VoxelShape[])new VoxelShape[]{WallTorchBlock.box((double)5.0, (double)0.0, (double)14.0, (double)11.0, (double)6.0, (double)16.0), WallTorchBlock.box((double)6.5, (double)-0.5, (double)10.5, (double)9.5, (double)3.5, (double)13.5), WallTorchBlock.box((double)6.0, (double)5.5, (double)10.0, (double)10.0, (double)9.5, (double)14.0)});
            case Direction.EAST -> Shapes.or((VoxelShape)WallTorchBlock.box((double)3.0, (double)-3.5, (double)7.0, (double)5.0, (double)9.5, (double)9.0), (VoxelShape[])new VoxelShape[]{WallTorchBlock.box((double)0.0, (double)0.0, (double)5.0, (double)2.0, (double)6.0, (double)11.0), WallTorchBlock.box((double)2.5, (double)-0.5, (double)6.5, (double)5.5, (double)3.5, (double)9.5), WallTorchBlock.box((double)2.0, (double)5.5, (double)6.0, (double)6.0, (double)9.5, (double)10.0)});
            case Direction.WEST -> Shapes.or((VoxelShape)WallTorchBlock.box((double)11.0, (double)-3.5, (double)7.0, (double)13.0, (double)9.5, (double)9.0), (VoxelShape[])new VoxelShape[]{WallTorchBlock.box((double)14.0, (double)0.0, (double)5.0, (double)16.0, (double)6.0, (double)11.0), WallTorchBlock.box((double)10.5, (double)-0.5, (double)6.5, (double)13.5, (double)3.5, (double)9.5), WallTorchBlock.box((double)10.0, (double)5.5, (double)6.0, (double)14.0, (double)9.5, (double)10.0)});
        };
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (context.getClickedFace().getAxis() == Direction.Axis.Y) {
            return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)Direction.NORTH);
        }
        return (BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getClickedFace());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public boolean canSurvive(BlockState blockstate, LevelReader worldIn, BlockPos pos) {
        if (worldIn instanceof LevelAccessor) {
            LevelAccessor world = (LevelAccessor)worldIn;
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            return WallTorchBlockValidPlacementConditionProcedure.execute(world, x, y, z, blockstate);
        }
        return super.canSurvive(blockstate, worldIn, pos);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        return !state.canSurvive((LevelReader)world, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, world, currentPos, facingPos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState blockstate, Level world, BlockPos pos, RandomSource random) {
        super.animateTick(blockstate, world, pos, random);
        LocalPlayer entity = Minecraft.getInstance().player;
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        WallTorchOnRandomClientDisplayTickProcedure.execute((LevelAccessor)world, x, y, z, blockstate);
    }
}

