/*
 * Decompiled with CFR 0.152.
 */
package net.unusual.blockfactorysbosses.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.unusual.blockfactorysbosses.init.BlockFactorysBossesModEntities;
import net.unusual.blockfactorysbosses.procedures.IcespikeDieProcedure;
import net.unusual.blockfactorysbosses.procedures.SpikeHitProcedure;
import net.unusual.blockfactorysbosses.procedures.SpikeTickUpdateProcedure;

public class IceSpikeEntity
extends PathfinderMob {
    public final AnimationState spawnAnimationState = new AnimationState();
    public static final EntityDataAccessor<Integer> DATA_remaning_hit = SynchedEntityData.defineId(IceSpikeEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_hit_animation_time = SynchedEntityData.defineId(IceSpikeEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_SpawnAnimTime = SynchedEntityData.defineId(IceSpikeEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public IceSpikeEntity(EntityType<IceSpikeEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(true);
        this.setInvisible(true);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_remaning_hit, (Object)5);
        builder.define(DATA_hit_animation_time, (Object)0);
        builder.define(DATA_SpawnAnimTime, (Object)36);
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.bone_block.break"));
    }

    public boolean hurt(DamageSource damagesource, float amount) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        Level world = this.level();
        IceSpikeEntity entity = this;
        Entity sourceentity = damagesource.getEntity();
        Entity immediatesourceentity = damagesource.getDirectEntity();
        SpikeHitProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity);
        return false;
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    public boolean fireImmune() {
        return true;
    }

    public void die(DamageSource source) {
        super.die(source);
        IcespikeDieProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Dataremaning_hit", ((Integer)this.entityData.get(DATA_remaning_hit)).intValue());
        compound.putInt("Datahit_animation_time", ((Integer)this.entityData.get(DATA_hit_animation_time)).intValue());
        compound.putInt("DataSpawnAnimTime", ((Integer)this.entityData.get(DATA_SpawnAnimTime)).intValue());
    }

    public void tick() {
        if (this.level().isClientSide) {
            this.spawnAnimationState.animateWhen((Integer)this.getEntityData().get(DATA_SpawnAnimTime) > 0, this.tickCount);
        }
        super.tick();
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Dataremaning_hit")) {
            this.entityData.set(DATA_remaning_hit, (Object)compound.getInt("Dataremaning_hit"));
        }
        if (compound.contains("Datahit_animation_time")) {
            this.entityData.set(DATA_hit_animation_time, (Object)compound.getInt("Datahit_animation_time"));
        }
        if (compound.contains("DataSpawnAnimTime")) {
            this.entityData.set(DATA_SpawnAnimTime, (Object)compound.getInt("DataSpawnAnimTime"));
        }
    }

    public void baseTick() {
        super.baseTick();
        SpikeTickUpdateProcedure.execute((Entity)this);
    }

    public boolean canCollideWith(Entity entity) {
        return true;
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)BlockFactorysBossesModEntities.ICE_SPIKE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.getDifficulty() != Difficulty.PEACEFUL && Monster.isDarkEnoughToSpawn((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random) && Mob.checkMobSpawnRules((EntityType)entityType, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random), RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
        builder = builder.add(Attributes.MAX_HEALTH, 10.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 16.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        return builder;
    }
}

