/*
 * Decompiled with CFR 0.152.
 */
package net.unusual.blockfactorysbosses.mixins;

import net.minecraft.client.model.PlayerModel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.unusual.blockfactorysbosses.init.BlockFactorysBossesModAttributes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerModel.class})
public abstract class PlayerRollMixin<T extends LivingEntity> {
    @Inject(method={"setupAnim"}, at={@At(value="TAIL")})
    private void onSetupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!this.isRolling(player)) {
            return;
        }
        PlayerModel model = (PlayerModel)this;
        float roll = ((float)player.getAttribute(BlockFactorysBossesModAttributes.ROLL_ANIMTIME).getBaseValue() - 90.0f) / 10.0f;
        float angleleg = 0.0f;
        float anglearm = 0.0f;
        float anglehead = 0.0f;
        model.rightLeg.xRot = this.setupAngle(roll, model.rightLeg.xRot, 0);
        model.rightPants.xRot = this.setupAngle(roll, model.rightLeg.xRot, 0);
        model.leftLeg.xRot = this.setupAngle(roll, model.leftLeg.xRot, 0);
        model.leftPants.xRot = this.setupAngle(roll, model.leftLeg.xRot, 0);
        model.rightArm.xRot = this.setupAngle(roll, model.rightArm.xRot, 1);
        model.rightSleeve.xRot = this.setupAngle(roll, model.rightArm.xRot, 1);
        model.leftArm.xRot = this.setupAngle(roll, model.leftArm.xRot, 1);
        model.leftSleeve.xRot = this.setupAngle(roll, model.leftArm.xRot, 1);
        model.head.xRot = this.setupAngle(roll, model.head.xRot, 2);
        model.hat.xRot = this.setupAngle(roll, model.head.xRot, 2);
    }

    private float setupAngle(float roll, float i, int type) {
        if (type == 0) {
            return (1.0f - roll) * i + roll * -2.27f;
        }
        if (type == 1) {
            return (1.0f - roll) * i + roll * -0.64f;
        }
        if (type == 2) {
            return (1.0f - roll) * i + roll * 0.69f;
        }
        return 0.0f;
    }

    private boolean isRolling(Player player) {
        return player.getAttribute(BlockFactorysBossesModAttributes.ROLL_ANIMTIME).getBaseValue() >= 90.0 && player.getAttribute(BlockFactorysBossesModAttributes.ROLL_ANIMTIME).getBaseValue() <= 100.0;
    }
}

