/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.stages;

import dev.latvian.mods.kubejs.bindings.event.PlayerEvents;
import dev.latvian.mods.kubejs.net.AddStagePayload;
import dev.latvian.mods.kubejs.net.RemoveStagePayload;
import dev.latvian.mods.kubejs.net.SyncStagesPayload;
import dev.latvian.mods.kubejs.player.StageChangedEvent;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;

public interface Stages {
    public Player getPlayer();

    public boolean addNoUpdate(String var1);

    public boolean removeNoUpdate(String var1);

    public Collection<String> getAll();

    default public boolean has(String stage) {
        return this.getAll().contains(stage);
    }

    default public boolean add(String stage) {
        if (this.addNoUpdate(stage)) {
            Player player = this.getPlayer();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new AddStagePayload(player2.getUUID(), stage), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (PlayerEvents.STAGE_ADDED.hasListeners(stage)) {
                PlayerEvents.STAGE_ADDED.post(new StageChangedEvent(this.getPlayer(), this, stage), stage);
            }
            return true;
        }
        return false;
    }

    default public boolean remove(String stage) {
        if (this.removeNoUpdate(stage)) {
            Player player = this.getPlayer();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                PacketDistributor.sendToAllPlayers((CustomPacketPayload)new RemoveStagePayload(player2.getUUID(), stage), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (PlayerEvents.STAGE_REMOVED.hasListeners(stage)) {
                PlayerEvents.STAGE_REMOVED.post(new StageChangedEvent(this.getPlayer(), this, stage), stage);
            }
            return true;
        }
        return false;
    }

    default public boolean set(String stage, boolean enabled) {
        return enabled ? this.add(stage) : this.remove(stage);
    }

    default public boolean toggle(String stage) {
        return this.set(stage, !this.has(stage));
    }

    default public boolean clear() {
        Collection<String> all = this.getAll();
        if (all.isEmpty()) {
            return false;
        }
        for (String s : new ArrayList<String>(all)) {
            this.remove(s);
        }
        return true;
    }

    default public void sync() {
        Player player = this.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PacketDistributor.sendToPlayer((ServerPlayer)player2, (CustomPacketPayload)new SyncStagesPayload(this.getAll()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    default public void replace(Collection<String> stages) {
        Collection<String> all = this.getAll();
        for (String s : new ArrayList<String>(all)) {
            this.removeNoUpdate(s);
        }
        for (String s : stages) {
            this.addNoUpdate(s);
        }
        this.sync();
    }
}

