/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.util;

import com.google.gson.JsonPrimitive;
import com.mojang.serialization.Codec;
import dev.latvian.mods.kubejs.KubeJSCodecs;
import dev.latvian.mods.kubejs.util.TickDuration;
import io.netty.buffer.ByteBuf;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public interface TimeJS {
    public static final Pattern TEMPORAL_AMOUNT_PATTERN = Pattern.compile("(\\d+)\\s*(y|M|d|w|h|m|s|ms|ns|t)\\b");
    public static final Codec<Duration> DURATION = KubeJSCodecs.stringResolverCodec(Duration::toString, TimeJS::durationOf);
    public static final StreamCodec<ByteBuf, Duration> DURATION_STREAM = ByteBufCodecs.STRING_UTF8.map(TimeJS::durationOf, Duration::toString);

    public static TemporalAmount temporalAmountOf(Object o) {
        if (o instanceof TemporalAmount) {
            TemporalAmount d = (TemporalAmount)o;
            return d;
        }
        if (o instanceof Number) {
            Number n = (Number)o;
            return Duration.ofMillis(n.longValue());
        }
        if (o instanceof CharSequence) {
            Matcher matcher = TEMPORAL_AMOUNT_PATTERN.matcher(o.toString());
            long millis = 0L;
            long nanos = 0L;
            long ticks = -1L;
            block24: while (matcher.find()) {
                double amount = Double.parseDouble(matcher.group(1));
                switch (matcher.group(2)) {
                    case "t": {
                        if (ticks == -1L) {
                            ticks = 0L;
                        }
                        ticks = (long)((double)ticks + amount);
                        continue block24;
                    }
                    case "ns": {
                        nanos += (long)amount;
                        continue block24;
                    }
                    case "ms": {
                        millis += (long)amount;
                        continue block24;
                    }
                    case "s": {
                        millis = (long)(amount * 1000.0);
                        continue block24;
                    }
                    case "m": {
                        millis = (long)(amount * 60000.0);
                        continue block24;
                    }
                    case "h": {
                        millis = (long)(amount * 60000.0) * 60L;
                        continue block24;
                    }
                    case "d": {
                        millis = (long)(amount * 24.0 * 86400.0) * 1000L;
                        continue block24;
                    }
                    case "w": {
                        millis = (long)(amount * 24.0 * 86400.0) * 7000L;
                        continue block24;
                    }
                    case "M": {
                        millis = (long)(amount * 3.1556952E7 / 12.0) * 1000L;
                        continue block24;
                    }
                    case "y": {
                        millis = (long)(amount * 3.1556952E7) * 1000L;
                        continue block24;
                    }
                }
                throw new IllegalArgumentException("Invalid temporal unit: " + matcher.group(2));
            }
            if (ticks != -1L) {
                return new TickDuration(ticks + millis / 50L);
            }
            return Duration.ofMillis(millis).plusNanos(nanos);
        }
        throw new IllegalArgumentException("Invalid temporal amount: " + String.valueOf(o));
    }

    public static long tickDurationOf(Object o) {
        if (o instanceof Number) {
            Number n = (Number)o;
            return n.longValue();
        }
        if (o instanceof JsonPrimitive) {
            JsonPrimitive json = (JsonPrimitive)o;
            return json.getAsLong();
        }
        TemporalAmount t = TimeJS.temporalAmountOf(o);
        if (t instanceof TickDuration) {
            TickDuration d = (TickDuration)t;
            return d.ticks();
        }
        if (t instanceof Duration) {
            Duration d = (Duration)t;
            return d.toMillis() / 50L;
        }
        return 0L;
    }

    public static Duration durationOf(Object o) {
        TemporalAmount t = TimeJS.temporalAmountOf(o);
        if (t instanceof Duration) {
            Duration d = (Duration)t;
            return d;
        }
        if (t instanceof TickDuration) {
            TickDuration d = (TickDuration)t;
            return Duration.ofMillis(d.ticks() * 50L);
        }
        Duration d = Duration.ZERO;
        for (TemporalUnit unit : t.getUnits()) {
            d = d.plus(t.get(unit), unit);
        }
        return d;
    }

    public static void appendTimestamp(StringBuilder builder, Calendar calendar) {
        int h = calendar.get(11);
        int m = calendar.get(12);
        int s = calendar.get(13);
        if (h < 10) {
            builder.append('0');
        }
        builder.append(h);
        builder.append(':');
        if (m < 10) {
            builder.append('0');
        }
        builder.append(m);
        builder.append(':');
        if (s < 10) {
            builder.append('0');
        }
        builder.append(s);
    }

    public static String msToString(long ms) {
        if (ms < 1000L) {
            return ms + " ms";
        }
        return "%.3f".formatted(Float.valueOf((float)ms / 1000.0f)) + " s";
    }
}

