/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bakery.client;

import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.satisfy.bakery.client.gui.StreetSignEditGui;
import net.satisfy.bakery.client.renderer.block.BreadBoxRenderer;
import net.satisfy.bakery.client.renderer.block.CakeDisplayRenderer;
import net.satisfy.bakery.client.renderer.block.CakeStandRenderer;
import net.satisfy.bakery.client.renderer.block.CompletionistBannerRenderer;
import net.satisfy.bakery.client.renderer.block.CupcakeDisplayRenderer;
import net.satisfy.bakery.client.renderer.block.StorageBlockEntityRenderer;
import net.satisfy.bakery.client.renderer.block.StorageTypeRenderer;
import net.satisfy.bakery.client.renderer.block.StreetSignBlockRenderer;
import net.satisfy.bakery.client.renderer.block.TrayRenderer;
import net.satisfy.bakery.client.renderer.block.WallDisplayRenderer;
import net.satisfy.bakery.core.block.entity.StreetSignBlockEntity;
import net.satisfy.bakery.core.registry.EntityTypeRegistry;
import net.satisfy.bakery.core.registry.ObjectRegistry;
import net.satisfy.bakery.core.registry.StorageTypeRegistry;

@OnlyIn(value=Dist.CLIENT)
public class BakeryClient {
    public static void initClient() {
        RenderTypeRegistry.register((RenderType)RenderType.cutout(), (Block[])new Block[]{(Block)ObjectRegistry.CAKE_STAND.get(), (Block)ObjectRegistry.IRON_TABLE.get(), (Block)ObjectRegistry.IRON_CHAIR.get(), (Block)ObjectRegistry.JAR.get(), (Block)ObjectRegistry.SWEETBERRY_JAM.get(), (Block)ObjectRegistry.CHOCOLATE_JAM.get(), (Block)ObjectRegistry.STRAWBERRY_JAM.get(), (Block)ObjectRegistry.GLOWBERRY_JAM.get(), (Block)ObjectRegistry.APPLE_JAM.get(), (Block)ObjectRegistry.CAKE_DISPLAY.get(), (Block)ObjectRegistry.SMALL_COOKING_POT.get(), (Block)ObjectRegistry.IRON_BENCH.get(), (Block)ObjectRegistry.BAKER_STATION.get(), (Block)ObjectRegistry.TRAY.get()});
        BakeryClient.registerStorageType();
        BakeryClient.registerBlockEntityRenderer();
        RenderTypeRegistry.register((RenderType)RenderType.translucent(), (Block[])new Block[]{(Block)ObjectRegistry.CAKE_STAND.get()});
    }

    public static void openStreetSignScreen(StreetSignBlockEntity entity) {
        Minecraft.getInstance().setScreen((Screen)new StreetSignEditGui(entity));
    }

    public static void preInitClient() {
        BakeryClient.registerEntityModelLayer();
    }

    public static void registerStorageType(ResourceLocation location, StorageTypeRenderer renderer) {
        StorageBlockEntityRenderer.registerStorageType(location, renderer);
    }

    public static void registerStorageType() {
        BakeryClient.registerStorageType(StorageTypeRegistry.CAKE_STAND, new CakeStandRenderer());
        BakeryClient.registerStorageType(StorageTypeRegistry.TRAY, new TrayRenderer());
        BakeryClient.registerStorageType(StorageTypeRegistry.BREADBOX, new BreadBoxRenderer());
        BakeryClient.registerStorageType(StorageTypeRegistry.CAKE_DISPLAY, new CakeDisplayRenderer());
        BakeryClient.registerStorageType(StorageTypeRegistry.CUPCAKE_DISPLAY, new CupcakeDisplayRenderer());
        BakeryClient.registerStorageType(StorageTypeRegistry.WALL_DISPLAY, new WallDisplayRenderer());
    }

    public static void registerBlockEntityRenderer() {
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)EntityTypeRegistry.BAKERY_BANNER.get()), CompletionistBannerRenderer::new);
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)EntityTypeRegistry.STORAGE_ENTITY.get()), context -> new StorageBlockEntityRenderer());
        BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)EntityTypeRegistry.STREET_SIGN_BLOCK_ENTITY.get()), context -> new StreetSignBlockRenderer());
    }

    public static void registerEntityModelLayer() {
        EntityModelLayerRegistry.register((ModelLayerLocation)CompletionistBannerRenderer.LAYER_LOCATION, CompletionistBannerRenderer::createBodyLayer);
    }
}

