/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bakery.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.satisfy.bakery.client.renderer.block.StorageTypeRenderer;
import net.satisfy.bakery.core.block.entity.StorageBlockEntity;
import net.satisfy.farm_and_charm.client.util.ClientUtil;

@OnlyIn(value=Dist.CLIENT)
public class CakeDisplayRenderer
implements StorageTypeRenderer {
    @Override
    public void render(StorageBlockEntity entity, PoseStack matrices, MultiBufferSource vertexConsumers, NonNullList<ItemStack> itemStacks) {
        int invSize = 6;
        float scale = 0.35f;
        float itemScaleY = 0.4f;
        float yOffsetFirstColumn = 1.15f;
        float yOffsetSecondColumn = 0.25f;
        float zOffset = -0.45f;
        float xOffsetModifier = 2.1f;
        float secondColumnAdditionalOffset = -1.5f;
        float firstColumnLeftShift = 1.2f;
        for (int i = 0; i < invSize; ++i) {
            ItemStack stack = (ItemStack)itemStacks.get(i);
            if (stack.isEmpty() || stack.getItem() instanceof BlockItem) continue;
            matrices.pushPose();
            matrices.scale(scale, itemScaleY, scale);
            boolean isFirstColumn = i < invSize / 2;
            float xOffset = (float)(i - 1) * xOffsetModifier + (isFirstColumn ? firstColumnLeftShift : secondColumnAdditionalOffset);
            float yOffset = isFirstColumn ? yOffsetFirstColumn : yOffsetSecondColumn;
            matrices.translate(xOffset, yOffset, zOffset);
            matrices.mulPose(Axis.XP.rotationDegrees(90.0f));
            matrices.translate(-1.2f * (float)i, 1.0f, 0.0f);
            ClientUtil.renderItem((ItemStack)stack, (PoseStack)matrices, (MultiBufferSource)vertexConsumers, (BlockEntity)entity);
            matrices.popPose();
        }
    }
}

