/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bakery.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.satisfy.bakery.client.renderer.block.StorageTypeRenderer;
import net.satisfy.bakery.core.block.entity.StorageBlockEntity;
import net.satisfy.farm_and_charm.client.util.ClientUtil;

@OnlyIn(value=Dist.CLIENT)
public class CakeStandRenderer
implements StorageTypeRenderer {
    @Override
    public void render(StorageBlockEntity entity, PoseStack matrices, MultiBufferSource vertexConsumers, NonNullList<ItemStack> itemStacks) {
        for (int i = 0; i < itemStacks.size(); ++i) {
            ItemStack stack = (ItemStack)itemStacks.get(i);
            if (stack.isEmpty()) continue;
            matrices.pushPose();
            Item item = stack.getItem();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                matrices.scale(0.65f, 0.65f, 0.65f);
                matrices.translate(-0.5, (double)0.8f, -0.5);
                ClientUtil.renderBlockFromItem((BlockItem)blockItem, (PoseStack)matrices, (MultiBufferSource)vertexConsumers, (BlockEntity)entity);
            } else {
                matrices.scale(0.4f, 0.4f, 0.4f);
                if (i == 0) {
                    matrices.translate(-0.4f, 1.3f, 0.4f);
                } else if (i == 1) {
                    matrices.translate(-0.2f, 1.3f, -0.4f);
                } else {
                    matrices.translate(0.4f, 1.3f, 0.2f);
                }
                matrices.mulPose(Axis.XP.rotationDegrees(90.0f));
                ClientUtil.renderItem((ItemStack)stack, (PoseStack)matrices, (MultiBufferSource)vertexConsumers, (BlockEntity)entity);
            }
            matrices.popPose();
        }
    }
}

