/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bakery.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.satisfy.bakery.client.renderer.block.StorageTypeRenderer;
import net.satisfy.bakery.core.block.entity.StorageBlockEntity;
import net.satisfy.bakery.core.registry.ObjectRegistry;
import net.satisfy.farm_and_charm.client.util.ClientUtil;

@OnlyIn(value=Dist.CLIENT)
public class TrayRenderer
implements StorageTypeRenderer {
    @Override
    public void render(StorageBlockEntity entity, PoseStack matrices, MultiBufferSource vertexConsumers, NonNullList<ItemStack> itemStacks) {
        matrices.translate(0.0, 0.3, (double)0.2f);
        matrices.scale(0.5f, 0.5f, 0.5f);
        matrices.mulPose(Axis.YP.rotationDegrees(90.0f));
        for (int i = 0; i < itemStacks.size(); ++i) {
            ItemStack stack = (ItemStack)itemStacks.get(i);
            if (stack.isEmpty()) continue;
            matrices.pushPose();
            Item item = stack.getItem();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                if (blockItem.getBlock() == ObjectRegistry.CRUSTY_BREAD_BLOCK.get()) {
                    matrices.translate(-0.6f, -0.5f, -1.0f);
                    matrices.scale(2.0f, 2.0f, 2.0f);
                    ClientUtil.renderBlockFromItem((BlockItem)blockItem, (PoseStack)matrices, (MultiBufferSource)vertexConsumers, (BlockEntity)entity);
                } else if (blockItem.getBlock() == ObjectRegistry.BUN_BLOCK.get()) {
                    matrices.translate(-0.6f, -0.5f, -1.0f);
                    matrices.scale(2.0f, 2.0f, 2.0f);
                    ClientUtil.renderBlockFromItem((BlockItem)blockItem, (PoseStack)matrices, (MultiBufferSource)vertexConsumers, (BlockEntity)entity);
                } else if (blockItem.getBlock() == ObjectRegistry.BREAD_BLOCK.get()) {
                    matrices.translate(-0.6f, -0.5f, 1.0f);
                    matrices.scale(2.0f, 2.0f, 2.0f);
                    matrices.mulPose(Axis.YP.rotationDegrees(90.0f));
                    ClientUtil.renderBlockFromItem((BlockItem)blockItem, (PoseStack)matrices, (MultiBufferSource)vertexConsumers, (BlockEntity)entity);
                } else if (blockItem.getBlock() == ObjectRegistry.BRAIDED_BREAD_BLOCK.get()) {
                    matrices.translate(-0.6f, -0.5f, 1.0f);
                    matrices.scale(2.0f, 2.0f, 2.0f);
                    matrices.mulPose(Axis.YP.rotationDegrees(90.0f));
                    ClientUtil.renderBlockFromItem((BlockItem)blockItem, (PoseStack)matrices, (MultiBufferSource)vertexConsumers, (BlockEntity)entity);
                } else if (blockItem.getBlock() == ObjectRegistry.TOAST_BLOCK.get()) {
                    matrices.translate(-0.6f, -0.5f, 1.0f);
                    matrices.scale(2.0f, 2.0f, 2.0f);
                    matrices.mulPose(Axis.YP.rotationDegrees(90.0f));
                    ClientUtil.renderBlockFromItem((BlockItem)blockItem, (PoseStack)matrices, (MultiBufferSource)vertexConsumers, (BlockEntity)entity);
                } else if (blockItem.getBlock() == ObjectRegistry.BAGUETTE_BLOCK.get()) {
                    matrices.translate(-0.3f, -0.5f, 0.7f);
                    matrices.scale(1.4f, 1.4f, 1.4f);
                    matrices.mulPose(Axis.YP.rotationDegrees(90.0f));
                    ClientUtil.renderBlockFromItem((BlockItem)blockItem, (PoseStack)matrices, (MultiBufferSource)vertexConsumers, (BlockEntity)entity);
                } else {
                    matrices.translate(0.1, -0.5, (double)-0.4f);
                    matrices.scale(0.8f, 0.8f, 0.8f);
                    ClientUtil.renderBlockFromItem((BlockItem)blockItem, (PoseStack)matrices, (MultiBufferSource)vertexConsumers, (BlockEntity)entity);
                }
            } else {
                matrices.translate(0.2f * (float)i, 0.0f, 0.0f);
                matrices.mulPose(Axis.YN.rotationDegrees(66.0f));
                ClientUtil.renderItem((ItemStack)stack, (PoseStack)matrices, (MultiBufferSource)vertexConsumers, (BlockEntity)entity);
            }
            matrices.popPose();
        }
    }
}

