/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bakery.core.block;

import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.bakery.core.registry.ObjectRegistry;
import org.jetbrains.annotations.NotNull;

public class CookieBlock
extends Block {
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.125, (double)0.4375, (double)0.0625, (double)0.4375), (VoxelShape[])new VoxelShape[]{Shapes.box((double)0.125, (double)0.0, (double)0.5625, (double)0.4375, (double)0.0625, (double)0.875), Shapes.box((double)0.5625, (double)0.0, (double)0.125, (double)0.875, (double)0.0625, (double)0.4375), Shapes.box((double)0.5625, (double)0.0, (double)0.5625, (double)0.875, (double)0.0625, (double)0.875)});

    public CookieBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, world, pos, block, fromPos, isMoving);
        if (!world.isClientSide && !this.canSurvive(state, (LevelReader)world, pos)) {
            world.destroyBlock(pos, true);
        }
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        return !world.isEmptyBlock(pos.below());
    }

    protected ItemInteractionResult useItemOn(ItemStack itemStack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!world.isClientSide) {
            if (state.is((Block)ObjectRegistry.SWEETBERRY_COOKIE_BLOCK.get())) {
                this.popItem(world, pos, new ItemStack((ItemLike)ObjectRegistry.SWEETBERRY_GLAZED_COOKIE.get(), 4));
            } else if (state.is((Block)ObjectRegistry.CHOCOLATE_COOKIE_BLOCK.get())) {
                this.popItem(world, pos, new ItemStack((ItemLike)ObjectRegistry.CHOCOLATE_GLAZED_COOKIE.get(), 4));
            } else if (state.is((Block)ObjectRegistry.STRAWBERRY_COOKIE_BLOCK.get())) {
                this.popItem(world, pos, new ItemStack((ItemLike)ObjectRegistry.STRAWBERRY_GLAZED_COOKIE.get(), 4));
            }
            world.playSound(null, pos, SoundEvents.WOOL_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.levelEvent(2001, pos, Block.getId((BlockState)Blocks.CAKE.defaultBlockState()));
            world.removeBlock(pos, false);
            return ItemInteractionResult.sidedSuccess((boolean)false);
        }
        return super.useItemOn(itemStack, state, world, pos, player, hand, hit);
    }

    private void popItem(Level world, BlockPos pos, ItemStack stack) {
        Block.popResource((Level)world, (BlockPos)pos, (ItemStack)stack);
    }
}

