/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bakery.core.event;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.PlayerEvent;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.satisfy.bakery.core.registry.ObjectRegistry;
import net.satisfy.bakery.core.registry.SoundEventRegistry;
import org.jetbrains.annotations.Nullable;

public class CommonEvents {
    public static void init() {
        PlayerEvent.ATTACK_ENTITY.register(CommonEvents::attack);
    }

    public static EventResult attack(Player player, Level level, Entity target, InteractionHand hand, @Nullable EntityHitResult result) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.is((Item)ObjectRegistry.SMALL_COOKING_POT_ITEM.get())) {
            level.playSound(null, target.getX(), target.getY(), target.getZ(), (SoundEvent)SoundEventRegistry.COOKING_POT_HIT.get(), SoundSource.PLAYERS, 0.5f, 0.75f);
            target.hurt(level.damageSources().generic(), 1.2f);
            itemStack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            itemStack.applyComponents(DataComponentMap.builder().set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.builder().add(Attributes.ATTACK_SPEED, new AttributeModifier(Item.BASE_ATTACK_SPEED_ID, -2.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build()).build());
            if (target instanceof Mob) {
                Mob mob = (Mob)target;
                mob.setTarget((LivingEntity)player);
            }
            return EventResult.interruptTrue();
        }
        if (itemStack.is((Item)ObjectRegistry.ROLLING_PIN.get()) && !level.isClientSide) {
            level.playSound(null, target.getX(), target.getY(), target.getZ(), SoundEvents.WOOD_BREAK, SoundSource.PLAYERS, 1.0f, 0.5f);
            if (target instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)target;
                livingTarget.hurt(level.damageSources().generic(), 2.0f);
                livingTarget.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 120, 1));
                if (livingTarget instanceof Mob) {
                    Mob mob = (Mob)livingTarget;
                    mob.setTarget((LivingEntity)player);
                }
            }
            itemStack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            itemStack.applyComponents(DataComponentMap.builder().set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ItemAttributeModifiers.builder().add(Attributes.ATTACK_SPEED, new AttributeModifier(Item.BASE_ATTACK_SPEED_ID, -2.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build()).build());
            return EventResult.interruptTrue();
        }
        return EventResult.pass();
    }
}

