/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bakery.core.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.satisfy.bakery.core.block.entity.CabinetBlockEntity;
import net.satisfy.bakery.core.block.entity.CompletionistBannerEntity;
import net.satisfy.bakery.core.block.entity.SmallCookingPotBlockEntity;
import net.satisfy.bakery.core.block.entity.StorageBlockEntity;
import net.satisfy.bakery.core.block.entity.StreetSignBlockEntity;
import net.satisfy.bakery.core.registry.ObjectRegistry;
import net.satisfy.bakery.core.registry.StorageTypeRegistry;
import net.satisfy.bakery.core.util.BakeryIdentifier;

public class EntityTypeRegistry {
    private static final Registrar<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((String)"farm_and_charm", (ResourceKey)Registries.BLOCK_ENTITY_TYPE).getRegistrar();
    public static final RegistrySupplier<BlockEntityType<SmallCookingPotBlockEntity>> SMALL_COOKING_POT_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("small_cooking_pot", () -> BlockEntityType.Builder.of(SmallCookingPotBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.SMALL_COOKING_POT.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<CompletionistBannerEntity>> BAKERY_BANNER = EntityTypeRegistry.registerBlockEntity("bakery_banner", () -> BlockEntityType.Builder.of(CompletionistBannerEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.BAKERY_BANNER.get(), (Block)ObjectRegistry.BAKERY_WALL_BANNER.get()}).build(null));
    public static final RegistrySupplier<BlockEntityType<StorageBlockEntity>> STORAGE_ENTITY = EntityTypeRegistry.registerBlockEntity("storage", () -> BlockEntityType.Builder.of(StorageBlockEntity::new, (Block[])StorageTypeRegistry.registerBlocks(new HashSet<Block>()).toArray(new Block[0])).build(null));
    public static final RegistrySupplier<BlockEntityType<CabinetBlockEntity>> CABINET_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("cabinet", () -> BlockEntityType.Builder.of(CabinetBlockEntity::new, (Block[])EntityTypeRegistry.addCabinet(new HashSet<Block>()).toArray(new Block[0])).build(null));
    public static final RegistrySupplier<BlockEntityType<StreetSignBlockEntity>> STREET_SIGN_BLOCK_ENTITY = EntityTypeRegistry.registerBlockEntity("street_sign", () -> BlockEntityType.Builder.of(StreetSignBlockEntity::new, (Block[])new Block[]{(Block)ObjectRegistry.STREET_SIGN.get()}).build(null));

    public static Set<Block> addCabinet(Set<Block> blocks) {
        blocks.add((Block)ObjectRegistry.CABINET.get());
        blocks.add((Block)ObjectRegistry.DRAWER.get());
        blocks.add((Block)ObjectRegistry.WALL_CABINET.get());
        return blocks;
    }

    private static <T extends BlockEntityType<?>> RegistrySupplier<T> registerBlockEntity(String name, Supplier<T> type) {
        return BLOCK_ENTITY_TYPES.register(BakeryIdentifier.identifier(name), type);
    }

    public static void init() {
    }
}

