/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.generator.mycelial;

import com.buuz135.industrial.block.generator.mycelial.IMycelialGeneratorType;
import com.buuz135.industrial.plugin.jei.generator.MycelialGeneratorRecipe;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class CulinaryGeneratorType
implements IMycelialGeneratorType {
    @Override
    public String getName() {
        return "culinary";
    }

    @Override
    public IMycelialGeneratorType.Input[] getInputs() {
        return new IMycelialGeneratorType.Input[]{IMycelialGeneratorType.Input.SLOT};
    }

    @Override
    public List<BiPredicate<ItemStack, Integer>> getSlotInputPredicates() {
        return Arrays.asList((stack, slot) -> stack.getFoodProperties(null) != null);
    }

    @Override
    public List<Predicate<FluidStack>> getTankInputPredicates() {
        return new ArrayList<Predicate<FluidStack>>();
    }

    @Override
    public boolean canStart(INBTSerializable<CompoundTag>[] inputs) {
        return inputs.length > 0 && inputs[0] instanceof SidedInventoryComponent && ((SidedInventoryComponent)inputs[0]).getStackInSlot(0).getCount() > 0;
    }

    @Override
    public Pair<Integer, Integer> getTimeAndPowerGeneration(INBTSerializable<CompoundTag>[] inputs) {
        if (inputs.length > 0 && inputs[0] instanceof SidedInventoryComponent && ((SidedInventoryComponent)inputs[0]).getStackInSlot(0).getCount() > 0) {
            ItemStack food = ((SidedInventoryComponent)inputs[0]).getStackInSlot(0).copy();
            ((SidedInventoryComponent)inputs[0]).getStackInSlot(0).shrink(1);
            return this.calculate(food);
        }
        return Pair.of((Object)0, (Object)80);
    }

    @Override
    public DyeColor[] getInputColors() {
        return new DyeColor[]{DyeColor.BROWN};
    }

    @Override
    public Item getDisplay() {
        return Items.COOKED_BEEF;
    }

    @Override
    public int getSlotSize() {
        return 64;
    }

    @Override
    public List<MycelialGeneratorRecipe> getRecipes(RegistryAccess registryAccess) {
        return BuiltInRegistries.ITEM.stream().map(ItemStack::new).filter(itemStack -> itemStack.getFoodProperties(null) != null).map(item -> new MycelialGeneratorRecipe(Collections.singletonList(Collections.singletonList(Ingredient.of((ItemStack[])new ItemStack[]{item}))), new ArrayList<List<FluidStack>>(), (Integer)this.calculate((ItemStack)item).getLeft(), (Integer)this.calculate((ItemStack)item).getRight())).collect(Collectors.toList());
    }

    private Pair<Integer, Integer> calculate(ItemStack stack) {
        FoodProperties food = stack.getItem().getFoodProperties(stack, null);
        if (food != null) {
            return Pair.of((Object)(food.nutrition() * 160), (Object)((int)(food.saturation() * 80.0f)));
        }
        return Pair.of((Object)0, (Object)0);
    }

    @Override
    public ShapedRecipeBuilder addIngredients(ShapedRecipeBuilder recipeBuilder) {
        recipeBuilder = recipeBuilder.define(Character.valueOf('B'), Tags.Items.CROPS).define(Character.valueOf('C'), (ItemLike)Items.COOKED_BEEF).define(Character.valueOf('M'), IndustrialTags.Items.MACHINE_FRAME_SIMPLE);
        return recipeBuilder;
    }
}

