/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.generator.mycelial;

import com.buuz135.industrial.block.generator.mycelial.IMycelialGeneratorType;
import com.buuz135.industrial.plugin.jei.generator.MycelialGeneratorRecipe;
import com.buuz135.industrial.utils.IndustrialTags;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.LingeringPotionItem;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class PotionGeneratorType
implements IMycelialGeneratorType {
    @Override
    public String getName() {
        return "potion";
    }

    @Override
    public IMycelialGeneratorType.Input[] getInputs() {
        return new IMycelialGeneratorType.Input[]{IMycelialGeneratorType.Input.SLOT};
    }

    @Override
    public List<BiPredicate<ItemStack, Integer>> getSlotInputPredicates() {
        return Arrays.asList((stack, slot) -> stack.getItem() instanceof PotionItem);
    }

    @Override
    public List<Predicate<FluidStack>> getTankInputPredicates() {
        return new ArrayList<Predicate<FluidStack>>();
    }

    @Override
    public boolean canStart(INBTSerializable<CompoundTag>[] inputs) {
        return inputs.length > 0 && inputs[0] instanceof SidedInventoryComponent && ((SidedInventoryComponent)inputs[0]).getStackInSlot(0).getCount() > 0 && this.getSlotInputPredicates().get(0).test(((SidedInventoryComponent)inputs[0]).getStackInSlot(0), 0);
    }

    @Override
    public Pair<Integer, Integer> getTimeAndPowerGeneration(INBTSerializable<CompoundTag>[] inputs) {
        if (inputs.length > 0 && inputs[0] instanceof SidedInventoryComponent && ((SidedInventoryComponent)inputs[0]).getStackInSlot(0).getCount() > 0) {
            ItemStack calculate = ((SidedInventoryComponent)inputs[0]).getStackInSlot(0).copy();
            ItemStack stack = ((SidedInventoryComponent)inputs[0]).getStackInSlot(0);
            if (stack.getCount() == 1) {
                ((SidedInventoryComponent)inputs[0]).setStackInSlot(0, new ItemStack((ItemLike)Items.GLASS_BOTTLE));
            } else {
                stack.shrink(1);
            }
            return this.calculate(calculate);
        }
        return Pair.of((Object)0, (Object)80);
    }

    @Override
    public DyeColor[] getInputColors() {
        return new DyeColor[]{DyeColor.PURPLE};
    }

    @Override
    public Item getDisplay() {
        return Items.POTION;
    }

    @Override
    public int getSlotSize() {
        return 1;
    }

    @Override
    public List<MycelialGeneratorRecipe> getRecipes(RegistryAccess registryAccess) {
        return registryAccess.registryOrThrow(Registries.POTION).stream().filter(potion -> potion != Potions.WATER).map(effect -> Arrays.asList(PotionContents.createItemStack((Item)Items.POTION, (Holder)Holder.direct((Object)effect)), PotionContents.createItemStack((Item)Items.SPLASH_POTION, (Holder)Holder.direct((Object)effect)), PotionContents.createItemStack((Item)Items.LINGERING_POTION, (Holder)Holder.direct((Object)effect)))).flatMap(Collection::stream).map(stack -> new MycelialGeneratorRecipe(Collections.singletonList(Collections.singletonList(Ingredient.of((ItemStack[])new ItemStack[]{stack}))), new ArrayList<List<FluidStack>>(), (Integer)this.calculate((ItemStack)stack).getLeft(), (Integer)this.calculate((ItemStack)stack).getRight())).collect(Collectors.toList());
    }

    private Pair<Integer, Integer> calculate(ItemStack stack) {
        PotionContents potion = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
        int duration = 80;
        int amplifier = 1;
        for (MobEffectInstance potionEffect : potion.getAllEffects()) {
            duration += potionEffect.getDuration();
            amplifier += potionEffect.getAmplifier();
        }
        double powValue = 2.0;
        if (stack.getItem() instanceof ThrowablePotionItem) {
            powValue = 2.5;
        }
        if (stack.getItem() instanceof LingeringPotionItem) {
            powValue = 3.0;
        }
        return Pair.of((Object)duration, (Object)((int)(Math.pow(amplifier, powValue) * 10.0)));
    }

    @Override
    public ShapedRecipeBuilder addIngredients(ShapedRecipeBuilder recipeBuilder) {
        recipeBuilder = recipeBuilder.define(Character.valueOf('B'), (ItemLike)Items.NETHER_WART).define(Character.valueOf('C'), (ItemLike)Blocks.BREWING_STAND).define(Character.valueOf('M'), IndustrialTags.Items.MACHINE_FRAME_ADVANCED);
        return recipeBuilder;
    }
}

