/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.plugin.jei.category;

import com.buuz135.industrial.plugin.jei.IndustrialRecipeTypes;
import com.buuz135.industrial.recipe.LaserDrillOreRecipe;
import com.buuz135.industrial.recipe.LaserDrillRarity;
import com.buuz135.industrial.recipe.data.EntityData;
import com.buuz135.industrial.recipe.data.EntityIngredient;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.client.screen.asset.DefaultAssetProvider;
import com.hrznstudio.titanium.util.AssetUtil;
import java.util.Arrays;
import java.util.Objects;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.inputs.IJeiInputHandler;
import mezz.jei.api.gui.inputs.IJeiUserInput;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.dimension.DimensionType;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.common.util.TriPredicate;
import org.apache.commons.lang3.text.WordUtils;

public class LaserDrillOreCategory
implements IRecipeCategory<LaserDrillOreRecipe> {
    private IGuiHelper guiHelper;
    public static final ScreenRectangle LEFT = new ScreenRectangle(0, 70, 16, 16);
    public static final ScreenRectangle RIGHT = new ScreenRectangle(137, 70, 16, 16);

    public LaserDrillOreCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
    }

    public Component getTitle() {
        return Component.literal((String)Component.translatable((String)"text.industrialforegoing.jei.recipe.laser_drill_items").getString());
    }

    public IDrawable getBackground() {
        return this.guiHelper.drawableBuilder(ResourceLocation.fromNamespaceAndPath((String)"industrialforegoing", (String)"textures/gui/jei.png"), 0, 0, 82, 26).addPadding(0, 69, 35, 35).build();
    }

    public IDrawable getIcon() {
        return null;
    }

    public RecipeType<LaserDrillOreRecipe> getRecipeType() {
        return IndustrialRecipeTypes.LASER_ORE;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, LaserDrillOreRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 36, 5).addIngredients(recipe.catalyst);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 96, 5).addIngredients(((SizedIngredient)recipe.output).ingredient());
    }

    public void draw(LaserDrillOreRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        int recipeWidth = 152;
        if (recipe.pointer > 0) {
            AssetUtil.drawAsset((GuiGraphics)guiGraphics, (Screen)Minecraft.getInstance().screen, (IAsset)DefaultAssetProvider.DEFAULT_PROVIDER.getAsset(AssetTypes.BUTTON_ARROW_LEFT), (int)0, (int)70);
        }
        if (recipe.pointer < recipe.rarity.size() - 1) {
            AssetUtil.drawAsset((GuiGraphics)guiGraphics, (Screen)Minecraft.getInstance().screen, (IAsset)DefaultAssetProvider.DEFAULT_PROVIDER.getAsset(AssetTypes.BUTTON_ARROW_RIGHT), (int)137, (int)70);
        }
        ResourceLocation toasts = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"toast/tree");
        int n = recipeWidth / 10 * 2;
        Objects.requireNonNull(Minecraft.getInstance().font);
        guiGraphics.blitSprite(toasts, n, 30 + (9 + 2) * 4, 20, 20);
        int n2 = recipeWidth / 10 * 7;
        Objects.requireNonNull(Minecraft.getInstance().font);
        guiGraphics.blitSprite(toasts, n2, 30 + (9 + 2) * 4, 20, 20);
        ResourceLocation icons = ResourceLocation.fromNamespaceAndPath((String)"neoforge", (String)"textures/gui/icons.png");
        int n3 = recipeWidth / 10 * 7 + 1;
        Objects.requireNonNull(Minecraft.getInstance().font);
        guiGraphics.blit(icons, n3, 30 + (9 + 2) * 4 + 3, 0, 16, 16, 16);
        String minY = Component.translatable((String)"text.industrialforegoing.miny").getString() + " " + ((LaserDrillRarity)recipe.rarity.get(recipe.pointer)).depth_min();
        String maxY = Component.translatable((String)"text.industrialforegoing.maxy").getString() + " " + ((LaserDrillRarity)recipe.rarity.get(recipe.pointer)).depth_max();
        String wight = Component.translatable((String)"text.industrialforegoing.weight").getString() + " " + ((LaserDrillRarity)recipe.rarity.get(recipe.pointer)).weight();
        String biomes = Component.translatable((String)"text.industrialforegoing.requirements").getString();
        guiGraphics.drawString(Minecraft.getInstance().font, String.valueOf(ChatFormatting.DARK_GRAY) + minY, recipeWidth / 10, 30, 0, false);
        guiGraphics.drawString(Minecraft.getInstance().font, String.valueOf(ChatFormatting.DARK_GRAY) + maxY, recipeWidth / 10 * 6, 30, 0, false);
        Font font = Minecraft.getInstance().font;
        String string = String.valueOf(ChatFormatting.DARK_GRAY) + wight;
        int n4 = recipeWidth / 10;
        Objects.requireNonNull(Minecraft.getInstance().font);
        guiGraphics.drawString(font, string, n4, 30 + (9 + 2), 0, false);
        if (recipe.entityData.isPresent()) {
            EntityIngredient entityIngredient = ((EntityData)recipe.entityData.get()).getEntity();
            Object name = entityIngredient.isTag() ? "#" + String.valueOf(entityIngredient.tag().location()) : entityIngredient.getType().getDescription().getString();
            String entity = "Over: " + (String)name;
            Font font2 = Minecraft.getInstance().font;
            String string2 = String.valueOf(ChatFormatting.DARK_GRAY) + entity;
            int n5 = recipeWidth / 10;
            Objects.requireNonNull(Minecraft.getInstance().font);
            guiGraphics.drawString(font2, string2, n5, 30 + (9 + 2) * 2, 0, false);
        }
        Font font3 = Minecraft.getInstance().font;
        String string3 = String.valueOf(ChatFormatting.DARK_GRAY) + String.valueOf(ChatFormatting.UNDERLINE) + biomes;
        int n6 = recipeWidth / 2 - Minecraft.getInstance().font.width(biomes) / 2;
        Objects.requireNonNull(Minecraft.getInstance().font);
        guiGraphics.drawString(font3, string3, n6, 30 + (9 + 2) * 3, 0, false);
    }

    public void getTooltip(ITooltipBuilder tooltip, LaserDrillOreRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        super.getTooltip(tooltip, (Object)recipe, recipeSlotsView, mouseX, mouseY);
        if (mouseX > 0.0 && mouseX < 15.0 && mouseY > 70.0 && mouseY < 85.0 && recipe.pointer > 0) {
            tooltip.add((FormattedText)Component.translatable((String)"text.industrialforegoing.button.jei.prev_rarity"));
        }
        if (mouseX > 137.0 && mouseX < 152.0 && mouseY > 70.0 && mouseY < 85.0 && recipe.pointer < recipe.rarity.size() - 1) {
            tooltip.add((FormattedText)Component.translatable((String)"text.industrialforegoing.button.jei.next_rarity"));
        }
        if (recipe.entityData.isPresent()) {
            EntityIngredient entityIngredient = ((EntityData)recipe.entityData.get()).getEntity();
            Object object = entityIngredient.isTag() ? "#" + String.valueOf(entityIngredient.tag().location()) : entityIngredient.getType().getDescription().getString();
            String text = Component.translatable((String)"text.industrialforegoing.jei.recipe.over").getString() + (String)object;
            int width = Minecraft.getInstance().font.width(text);
            if (mouseX > 12.0 && mouseX < (double)(12 + width + 4)) {
                Objects.requireNonNull(Minecraft.getInstance().font);
                if (mouseY > (double)(28 + (9 + 2) * 2)) {
                    Objects.requireNonNull(Minecraft.getInstance().font);
                    if (mouseY < (double)(28 + (9 + 2) * 3) && !((EntityData)recipe.entityData.get()).getData().isEmpty()) {
                        tooltip.add((FormattedText)Component.translatable((String)"text.industrialforegoing.tooltip.data").withStyle(ChatFormatting.UNDERLINE).withStyle(ChatFormatting.GOLD));
                        tooltip.add((FormattedText)((EntityData)recipe.entityData.get()).getDisplay());
                    }
                }
            }
        }
        if (mouseX > 26.0 && mouseX < 46.0) {
            Objects.requireNonNull(Minecraft.getInstance().font);
            if (mouseY > (double)(30 + (9 + 2) * 4)) {
                Objects.requireNonNull(Minecraft.getInstance().font);
                if (mouseY < (double)(30 + (9 + 2) * 4 + 20)) {
                    tooltip.add((FormattedText)Component.translatable((String)"text.industrialforegoing.tooltip.whitelisted_dimensions").withStyle(ChatFormatting.UNDERLINE).withStyle(ChatFormatting.GOLD));
                    if (((LaserDrillRarity)recipe.rarity.get(recipe.pointer)).dimensionRarity().whitelist().isEmpty()) {
                        tooltip.add((FormattedText)Component.literal((String)Component.translatable((String)"text.industrialforegoing.jei.recipe.any").getString()));
                    } else {
                        for (ResourceKey<DimensionType> resourceKey : ((LaserDrillRarity)recipe.rarity.get(recipe.pointer)).dimensionRarity().whitelist()) {
                            tooltip.add((FormattedText)Component.literal((String)("- " + WordUtils.capitalize((String)Arrays.stream(resourceKey.location().getPath().split("_")).reduce((string, string2) -> string + " " + string2).get()))));
                        }
                    }
                    tooltip.add((FormattedText)Component.empty());
                    tooltip.add((FormattedText)Component.translatable((String)"text.industrialforegoing.tooltip.whitelisted_biomes").withStyle(ChatFormatting.UNDERLINE).withStyle(ChatFormatting.GOLD));
                    if (((LaserDrillRarity)recipe.rarity.get(recipe.pointer)).biomeRarity().whitelist().isEmpty()) {
                        tooltip.add((FormattedText)Component.literal((String)Component.translatable((String)"text.industrialforegoing.jei.recipe.any").getString()));
                    } else {
                        for (TagKey tagKey : ((LaserDrillRarity)recipe.rarity.get(recipe.pointer)).biomeRarity().whitelist()) {
                            for (Holder biomeHolder : Minecraft.getInstance().level.registryAccess().registryOrThrow(Registries.BIOME).getTagOrEmpty(tagKey)) {
                                tooltip.add((FormattedText)Component.literal((String)"- ").append((Component)Component.translatable((String)("biome." + biomeHolder.getKey().location().getNamespace() + "." + biomeHolder.getKey().location().getPath()))));
                            }
                        }
                    }
                }
            }
        }
        if (mouseX > 104.0 && mouseX < 124.0) {
            Objects.requireNonNull(Minecraft.getInstance().font);
            if (mouseY > (double)(30 + (9 + 2) * 4)) {
                Objects.requireNonNull(Minecraft.getInstance().font);
                if (mouseY < (double)(30 + (9 + 2) * 4 + 20)) {
                    tooltip.add((FormattedText)Component.translatable((String)"text.industrialforegoing.tooltip.blacklisted_dimensions").withStyle(ChatFormatting.UNDERLINE).withStyle(ChatFormatting.GOLD));
                    if (((LaserDrillRarity)recipe.rarity.get(recipe.pointer)).dimensionRarity().blacklist().isEmpty()) {
                        tooltip.add((FormattedText)Component.literal((String)Component.translatable((String)"text.industrialforegoing.jei.recipe.none").getString()));
                    } else {
                        for (ResourceKey<DimensionType> resourceKey : ((LaserDrillRarity)recipe.rarity.get(recipe.pointer)).dimensionRarity().blacklist()) {
                            tooltip.add((FormattedText)Component.literal((String)("- " + WordUtils.capitalize((String)Arrays.stream(resourceKey.location().getPath().split("_")).reduce((string, string2) -> string + " " + string2).get()))));
                        }
                    }
                    tooltip.add((FormattedText)Component.empty());
                    tooltip.add((FormattedText)Component.translatable((String)"text.industrialforegoing.tooltip.blacklisted_biomes").withStyle(ChatFormatting.UNDERLINE).withStyle(ChatFormatting.GOLD));
                    if (((LaserDrillRarity)recipe.rarity.get(recipe.pointer)).biomeRarity().blacklist().isEmpty()) {
                        tooltip.add((FormattedText)Component.literal((String)Component.translatable((String)"text.industrialforegoing.jei.recipe.none").getString()));
                    } else {
                        for (TagKey tagKey : ((LaserDrillRarity)recipe.rarity.get(recipe.pointer)).biomeRarity().blacklist()) {
                            for (Holder biomeHolder : Minecraft.getInstance().level.registryAccess().registryOrThrow(Registries.BIOME).getTagOrEmpty(tagKey)) {
                                tooltip.add((FormattedText)Component.literal((String)"- ").append((Component)Component.translatable((String)("biome." + biomeHolder.getKey().location().getNamespace() + "." + biomeHolder.getKey().location().getPath()))));
                            }
                        }
                    }
                }
            }
        }
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, LaserDrillOreRecipe recipe, IFocusGroup focuses) {
        super.createRecipeExtras(builder, (Object)recipe, focuses);
        builder.addInputHandler(new ClickHandler<LaserDrillOreRecipe>(LEFT, recipe, (TriPredicate<Double, Double, IJeiUserInput>)((TriPredicate)(mouseX, mouseY, iJeiUserInput) -> {
            if (recipe.pointer > 0) {
                --recipe.pointer;
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                return true;
            }
            return false;
        })));
        builder.addInputHandler(new ClickHandler<LaserDrillOreRecipe>(RIGHT, recipe, (TriPredicate<Double, Double, IJeiUserInput>)((TriPredicate)(mouseX, mouseY, iJeiUserInput) -> {
            if (recipe.pointer < recipe.rarity.size() - 1) {
                ++recipe.pointer;
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                return true;
            }
            return false;
        })));
    }

    public record ClickHandler<T>(ScreenRectangle area, T recipe, TriPredicate<Double, Double, IJeiUserInput> handleInput) implements IJeiInputHandler
    {
        public ScreenRectangle getArea() {
            return this.area;
        }

        public boolean handleInput(double mouseX, double mouseY, IJeiUserInput input) {
            return this.handleInput.test((Object)mouseX, (Object)mouseY, (Object)input);
        }
    }
}

