/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils.explosion;

import net.minecraft.core.BlockPos;
import org.joml.Vector3f;

public class ShortPos2 {
    private BlockPos relativeTo;

    public ShortPos2(BlockPos relativeTo) {
        this.relativeTo = relativeTo;
    }

    public static int getIntPos(BlockPos position, BlockPos relativeTo) {
        if (position.getY() > 255) {
            position = new BlockPos(position.getX(), 255, position.getY());
        } else if (position.getY() < -64) {
            position = new BlockPos(position.getX(), 0, position.getY());
        }
        int xp = position.getX() - relativeTo.getX() + 2048;
        int yp = position.getY();
        int zp = position.getZ() - relativeTo.getZ() + 2048;
        return yp << 24 | xp << 12 | zp;
    }

    public static int getIntPos(Vector3f position, BlockPos relativeTo) {
        if (position.y() > 255.0f) {
            position.setComponent(1, 255.0f);
        } else if (position.y() < -64.0f) {
            position.setComponent(1, 0.0f);
        }
        int xp = (int)position.x() - relativeTo.getX() + 2048;
        int yp = (int)position.y();
        int zp = (int)position.z() - relativeTo.getZ() + 2048;
        return yp << 24 | xp << 12 | zp;
    }

    public static BlockPos getBlockPos(int intPos, BlockPos relativeTo) {
        int yp = intPos >> 24 & 0xFF;
        int xp = (intPos >> 12 & 0xFFF) - 2048;
        int zp = (intPos & 0xFFF) - 2048;
        int finalX = relativeTo.getX() + xp;
        int finalZ = relativeTo.getZ() + zp;
        return new BlockPos(finalX, yp, finalZ);
    }

    public BlockPos getRelativeTo() {
        return this.relativeTo;
    }

    public void setRelativeTo(BlockPos relativeTo) {
        this.relativeTo = relativeTo;
    }

    public int getIntPos(BlockPos pos) {
        return ShortPos2.getIntPos(pos, this.relativeTo);
    }

    public int getIntPos(Vector3f pos) {
        return ShortPos2.getIntPos(pos, this.relativeTo);
    }

    public BlockPos getActualPos(int intPos) {
        return ShortPos2.getBlockPos(intPos, this.relativeTo);
    }
}

