/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import mekanism.client.model.MekanismJavaModel;
import mekanism.client.model.ModelPartData;
import mekanism.generators.common.MekanismGenerators;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class ModelTurbine
extends MekanismJavaModel {
    public static final ModelLayerLocation TURBINE_LAYER = new ModelLayerLocation(MekanismGenerators.rl("turbine"), "main");
    private static final ResourceLocation TURBINE_TEXTURE = MekanismGenerators.rl("render/turbine.png");
    private static final float BLADE_ROTATE = 0.418879f;
    private static final ModelPartData EXTENSION_NORTH = new ModelPartData("extensionNorth", CubeListBuilder.create().texOffs(0, 9).addBox(-1.0f, 0.0f, -4.0f, 2.0f, 1.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)20.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.418879f), new ModelPartData[0]);
    private static final ModelPartData EXTENSION_EAST = new ModelPartData("extensionEast", CubeListBuilder.create().texOffs(0, 13).addBox(1.0f, 0.0f, -1.0f, 3.0f, 1.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)20.0f, (float)0.0f, (float)-0.418879f, (float)0.0f, (float)0.0f), new ModelPartData[0]);
    private static final ModelPartData EXTENSION_SOUTH = new ModelPartData("extensionSouth", CubeListBuilder.create().texOffs(0, 9).addBox(-1.0f, 0.0f, 1.0f, 2.0f, 1.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)20.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.418879f), new ModelPartData[0]);
    private static final ModelPartData EXTENSION_WEST = new ModelPartData("extensionWest", CubeListBuilder.create().texOffs(0, 13).addBox(-4.0f, 0.0f, -1.0f, 3.0f, 1.0f, 2.0f), PartPose.offsetAndRotation((float)0.0f, (float)20.0f, (float)0.0f, (float)0.418879f, (float)0.0f, (float)0.0f), new ModelPartData[0]);
    private static final ModelPartData BLADE_NORTH = new ModelPartData("bladeNorth", CubeListBuilder.create().addBox(-1.5f, 0.0f, -8.0f, 3.0f, 1.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)20.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.418879f), new ModelPartData[0]);
    private static final ModelPartData BLADE_EAST = new ModelPartData("bladeEast", CubeListBuilder.create().texOffs(0, 5).addBox(4.0f, 0.0f, -1.5f, 4.0f, 1.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)20.0f, (float)0.0f, (float)-0.418879f, (float)0.0f, (float)0.0f), new ModelPartData[0]);
    private static final ModelPartData BLADE_SOUTH = new ModelPartData("bladeSouth", CubeListBuilder.create().addBox(-1.5f, 0.0f, 4.0f, 3.0f, 1.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)20.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.418879f), new ModelPartData[0]);
    private static final ModelPartData BLADE_WEST = new ModelPartData("bladeWest", CubeListBuilder.create().texOffs(0, 5).addBox(-8.0f, 0.0f, -1.5f, 4.0f, 1.0f, 3.0f), PartPose.offsetAndRotation((float)0.0f, (float)20.0f, (float)0.0f, (float)0.418879f, (float)0.0f, (float)0.0f), new ModelPartData[0]);
    private final RenderType RENDER_TYPE = this.renderType(TURBINE_TEXTURE);
    private final List<ModelPart> parts;
    private final ModelPart bladeWest;
    private final ModelPart bladeEast;
    private final ModelPart bladeNorth;
    private final ModelPart bladeSouth;

    public static LayerDefinition createLayerDefinition() {
        return ModelTurbine.createLayerDefinition((int)16, (int)16, (ModelPartData[])new ModelPartData[]{EXTENSION_NORTH, EXTENSION_EAST, EXTENSION_SOUTH, EXTENSION_WEST, BLADE_NORTH, BLADE_EAST, BLADE_SOUTH, BLADE_WEST});
    }

    public ModelTurbine(EntityModelSet entityModelSet) {
        super(RenderType::entitySolid);
        ModelPart root = entityModelSet.bakeLayer(TURBINE_LAYER);
        this.parts = ModelTurbine.getRenderableParts((ModelPart)root, (ModelPartData[])new ModelPartData[]{EXTENSION_SOUTH, EXTENSION_WEST, EXTENSION_EAST, EXTENSION_NORTH});
        this.bladeWest = BLADE_WEST.getFromRoot(root);
        this.bladeEast = BLADE_EAST.getFromRoot(root);
        this.bladeNorth = BLADE_NORTH.getFromRoot(root);
        this.bladeSouth = BLADE_SOUTH.getFromRoot(root);
    }

    public VertexConsumer getBuffer(@NotNull MultiBufferSource renderer) {
        return renderer.getBuffer(this.RENDER_TYPE);
    }

    public void render(@NotNull PoseStack matrix, VertexConsumer buffer, int light, int overlayLight, int index) {
        matrix.pushPose();
        matrix.mulPose(Axis.YP.rotationDegrees((float)(index * 5)));
        this.renderToBuffer(matrix, buffer, light, overlayLight, -1);
        float scale = (float)index * 0.5f;
        float adjustedScale = scale / 16.0f;
        this.renderBlade(matrix, buffer, light, overlayLight, this.bladeWest, scale, adjustedScale, -0.25, 0.0);
        this.renderBlade(matrix, buffer, light, overlayLight, this.bladeEast, scale, adjustedScale, 0.25, 0.0);
        this.renderBlade(matrix, buffer, light, overlayLight, this.bladeNorth, adjustedScale, scale, 0.0, -0.25);
        this.renderBlade(matrix, buffer, light, overlayLight, this.bladeSouth, adjustedScale, scale, 0.0, 0.25);
        matrix.popPose();
    }

    public void renderToBuffer(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int light, int overlayLight, int color) {
        ModelTurbine.renderPartsToBuffer(this.parts, (PoseStack)poseStack, (VertexConsumer)vertexConsumer, (int)light, (int)overlayLight, (int)color);
    }

    private void renderBlade(@NotNull PoseStack matrix, @NotNull VertexConsumer vertexBuilder, int light, int overlayLight, ModelPart blade, float scaleX, float scaleZ, double transX, double transZ) {
        matrix.pushPose();
        matrix.translate(transX, 0.0, transZ);
        matrix.scale(1.0f + scaleX, 1.0f, 1.0f + scaleZ);
        matrix.translate(-transX, 0.0, -transZ);
        blade.render(matrix, vertexBuilder, light, overlayLight, -1);
        matrix.popPose();
    }
}

