/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.recipe_viewer.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.attribute.ChemicalAttributes;
import mekanism.api.datamaps.IMekanismDataMapTypes;
import mekanism.api.datamaps.chemical.attribute.CooledCoolant;
import mekanism.api.math.MathUtils;
import mekanism.api.providers.IChemicalProvider;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.client.recipe_viewer.RecipeViewerUtils;
import mekanism.client.recipe_viewer.emi.INamedRVRecipe;
import mekanism.common.registries.MekanismChemicals;
import mekanism.common.util.HeatUtils;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import org.jetbrains.annotations.Nullable;

public record FissionRecipeViewerRecipe(ResourceLocation id, @Nullable ChemicalStackIngredient inputCoolant, ChemicalStackIngredient fuel, ChemicalStack outputCoolant, ChemicalStack waste) implements INamedRVRecipe
{
    public static final Codec<FissionRecipeViewerRecipe> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(FissionRecipeViewerRecipe::id), (App)ChemicalStackIngredient.CODEC.optionalFieldOf("extra_input").forGetter(recipe -> Optional.ofNullable(recipe.inputCoolant())), (App)ChemicalStackIngredient.CODEC.fieldOf("input").forGetter(FissionRecipeViewerRecipe::fuel), (App)ChemicalStack.CODEC.fieldOf("secondary_output").forGetter(FissionRecipeViewerRecipe::outputCoolant), (App)ChemicalStack.CODEC.fieldOf("output").forGetter(FissionRecipeViewerRecipe::waste)).apply((Applicative)instance, (id, inputCoolant, fuel, outputCoolant, waste) -> new FissionRecipeViewerRecipe((ResourceLocation)id, inputCoolant.orElse(null), (ChemicalStackIngredient)fuel, (ChemicalStack)outputCoolant, (ChemicalStack)waste)));

    public FluidStackIngredient waterInput() {
        return IngredientCreatorAccess.fluid().from(FluidTags.WATER, MathUtils.clampToInt((long)this.outputCoolant().getAmount()));
    }

    public static List<FissionRecipeViewerRecipe> getFissionRecipes() {
        long amount;
        ArrayList<FissionRecipeViewerRecipe> recipes = new ArrayList<FissionRecipeViewerRecipe>();
        long energyPerFuel = MekanismGeneratorsConfig.generators.energyPerFissionFuel.get();
        long coolantAmount = Math.round((double)energyPerFuel * HeatUtils.getSteamEnergyEfficiency() / HeatUtils.getWaterThermalEnthalpy());
        recipes.add(new FissionRecipeViewerRecipe(RecipeViewerUtils.synthetic((ResourceLocation)MekanismGenerators.rl("water"), (String)"fission"), null, IngredientCreatorAccess.chemicalStack().fromHolder((Holder)MekanismChemicals.FISSILE_FUEL, 1), MekanismChemicals.STEAM.asStack(coolantAmount), MekanismChemicals.NUCLEAR_WASTE.asStack(1L)));
        for (Map.Entry entry : MekanismAPI.CHEMICAL_REGISTRY.getDataMap(IMekanismDataMapTypes.INSTANCE.cooledChemicalCoolant()).entrySet()) {
            ResourceKey key = (ResourceKey)entry.getKey();
            CooledCoolant coolant = (CooledCoolant)entry.getValue();
            amount = Math.round((double)energyPerFuel / coolant.thermalEnthalpy());
            recipes.add(new FissionRecipeViewerRecipe(RecipeViewerUtils.synthetic((ResourceLocation)key.location(), (String)"fission", (String)"mekanismgenerators"), IngredientCreatorAccess.chemicalStack().fromHolder((Holder)MekanismAPI.CHEMICAL_REGISTRY.getHolderOrThrow(key), amount), IngredientCreatorAccess.chemicalStack().fromHolder((Holder)MekanismChemicals.FISSILE_FUEL, 1), coolant.heat(amount), MekanismChemicals.NUCLEAR_WASTE.asStack(1L)));
        }
        for (Chemical chemical : MekanismAPI.CHEMICAL_REGISTRY) {
            ChemicalAttributes.CooledCoolant cooledCoolant = (ChemicalAttributes.CooledCoolant)chemical.getLegacy(ChemicalAttributes.CooledCoolant.class);
            if (cooledCoolant == null) continue;
            Chemical heatedCoolant = cooledCoolant.getHeatedChemical();
            amount = Math.round((double)energyPerFuel / cooledCoolant.getThermalEnthalpy());
            recipes.add(new FissionRecipeViewerRecipe(RecipeViewerUtils.synthetic((String)chemical.toString(), (String)"fission", (String)"mekanismgenerators"), IngredientCreatorAccess.chemicalStack().from((IChemicalProvider)chemical, amount), IngredientCreatorAccess.chemicalStack().fromHolder((Holder)MekanismChemicals.FISSILE_FUEL, 1), heatedCoolant.getStack(amount), MekanismChemicals.NUCLEAR_WASTE.asStack(1L)));
        }
        return recipes;
    }
}

