/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.client.render.data.RenderData;
import mekanism.client.render.tileentity.MultiblockTileEntityRenderer;
import mekanism.common.lib.multiblock.MultiblockData;
import mekanism.common.tile.prefab.TileEntityMultiblock;
import mekanism.common.util.WorldUtils;
import mekanism.generators.client.render.RenderTurbineRotor;
import mekanism.generators.common.content.turbine.TurbineMultiblockData;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import mekanism.generators.common.tile.turbine.TileEntityTurbineRotor;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;

@NothingNullByDefault
public class RenderIndustrialTurbine
extends MultiblockTileEntityRenderer<TurbineMultiblockData, TileEntityTurbineCasing> {
    public RenderIndustrialTurbine(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void render(TileEntityTurbineCasing tile, TurbineMultiblockData multiblock, float partialTick, PoseStack matrix, MultiBufferSource renderer, int light, int overlayLight, ProfilerFiller profiler) {
        int height;
        BlockPos pos = tile.getBlockPos();
        profiler.push("turbineRotor");
        if (RenderTurbineRotor.INSTANCE != null) {
            BlockPos.MutableBlockPos complexPos = new BlockPos.MutableBlockPos(multiblock.complex.getX(), multiblock.complex.getY(), multiblock.complex.getZ());
            VertexConsumer buffer = RenderTurbineRotor.INSTANCE.getBuffer(renderer);
            matrix.pushPose();
            matrix.translate((float)(complexPos.getX() - pos.getX()), (float)(complexPos.getY() - pos.getY()), (float)(complexPos.getZ() - pos.getZ()));
            while (true) {
                complexPos.move(Direction.DOWN);
                TileEntityTurbineRotor rotor = (TileEntityTurbineRotor)WorldUtils.getTileEntity(TileEntityTurbineRotor.class, (BlockGetter)tile.getLevel(), (BlockPos)complexPos);
                if (rotor == null) break;
                matrix.translate(0.0f, -1.0f, 0.0f);
                RenderTurbineRotor.INSTANCE.render(rotor, matrix, buffer, 0xF00000, overlayLight);
            }
            matrix.popPose();
        }
        profiler.pop();
        if (!multiblock.chemicalTank.isEmpty() && multiblock.length() > 0 && (height = multiblock.lowerVolume / (multiblock.length() * multiblock.width())) > 0) {
            RenderData data = RenderData.Builder.create((ChemicalStack)multiblock.chemicalTank.getStack()).of((MultiblockData)multiblock).height(height).build();
            this.renderObject(data, pos, matrix, renderer.getBuffer(Sheets.translucentCullBlockSheet()), overlayLight, multiblock.prevSteamScale);
        }
    }

    protected String getProfilerSection() {
        return "industrialTurbine";
    }

    protected boolean shouldRender(TileEntityTurbineCasing tile, TurbineMultiblockData multiblock, Vec3 camera) {
        return super.shouldRender((TileEntityMultiblock)tile, (MultiblockData)multiblock, camera) && multiblock.complex != null;
    }
}

