/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.render;

import com.klikli_dev.occultism.client.misc.ClientPentacleManager;
import com.klikli_dev.occultism.common.blockentity.GoldenSacrificialBowlBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.fml.ModList;

public class GoldenSacrificialBowlHUD
implements LayeredDraw.Layer {
    private static final GoldenSacrificialBowlHUD instance = new GoldenSacrificialBowlHUD();

    public static GoldenSacrificialBowlHUD get() {
        return instance;
    }

    public void render(GuiGraphics pGuiGraphics, DeltaTracker pDeltaTracker) {
        Minecraft mc = Minecraft.getInstance();
        HitResult hitResult = mc.hitResult;
        if (!(hitResult instanceof BlockHitResult)) {
            ClientPentacleManager.reset();
            return;
        }
        BlockHitResult blockHitResult = (BlockHitResult)hitResult;
        BlockPos pos = blockHitResult.getBlockPos();
        BlockEntity blockEntity = mc.level.getBlockEntity(pos);
        if (!(blockEntity instanceof GoldenSacrificialBowlBlockEntity)) {
            ClientPentacleManager.reset();
            return;
        }
        GoldenSacrificialBowlBlockEntity goldenBowl = (GoldenSacrificialBowlBlockEntity)blockEntity;
        ClientPentacleManager.rebuild(pos);
        if (!ModList.get().isLoaded("jade")) {
            Font font = mc.font;
            int x = pGuiGraphics.guiWidth() / 2;
            int y = pGuiGraphics.guiHeight() / 2 + 18;
            PoseStack pose = pGuiGraphics.pose();
            pose.pushPose();
            if (!ClientPentacleManager.lastPentacles.isEmpty()) {
                for (MutableComponent text : ClientPentacleManager.lastPentacles) {
                    pGuiGraphics.drawCenteredString(font, (Component)text, x, y, -1);
                    y += 9;
                }
            } else {
                pGuiGraphics.drawCenteredString(font, (Component)ClientPentacleManager.noPentacleFound.withStyle(ChatFormatting.YELLOW), x, y, -1);
            }
            pose.popPose();
        }
    }
}

