/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.block;

import com.google.common.collect.ImmutableList;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.klikli_dev.occultism.registry.OccultismParticles;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LargeCandleBlock
extends AbstractCandleBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<LargeCandleBlock> CODEC = LargeCandleBlock.simpleCodec(LargeCandleBlock::new);
    public static final IntegerProperty CANDLES = BlockStateProperties.CANDLES;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final ToIntFunction<BlockState> LIGHT_EMISSION = p_152848_ -> (Boolean)p_152848_.getValue((Property)LIT) != false ? 15 : 0;
    private static final Int2ObjectMap<List<Vec3>> PARTICLE_OFFSETS = (Int2ObjectMap)Util.make(() -> {
        Int2ObjectOpenHashMap int2objectmap = new Int2ObjectOpenHashMap();
        int2objectmap.defaultReturnValue((Object)ImmutableList.of((Object)new Vec3(0.5, 0.1, 0.5)));
        return Int2ObjectMaps.unmodifiable((Int2ObjectMap)int2objectmap);
    });
    private static final VoxelShape SHAPE = Stream.of(Block.box((double)7.0, (double)0.0, (double)10.0, (double)9.0, (double)4.0, (double)11.0), Block.box((double)10.0, (double)0.0, (double)8.0, (double)11.0, (double)3.0, (double)9.0), Block.box((double)10.0, (double)0.0, (double)6.0, (double)11.0, (double)1.0, (double)7.0), Block.box((double)11.0, (double)0.0, (double)7.0, (double)12.0, (double)1.0, (double)8.0), Block.box((double)7.0, (double)0.0, (double)11.0, (double)8.0, (double)1.0, (double)12.0), Block.box((double)6.0, (double)0.0, (double)10.0, (double)7.0, (double)1.0, (double)11.0), Block.box((double)4.0, (double)0.0, (double)7.0, (double)5.0, (double)1.0, (double)8.0), Block.box((double)5.0, (double)0.0, (double)6.0, (double)6.0, (double)1.0, (double)7.0), Block.box((double)7.0, (double)0.0, (double)5.0, (double)8.0, (double)2.0, (double)6.0), Block.box((double)10.0, (double)0.0, (double)7.0, (double)11.0, (double)5.0, (double)8.0), Block.box((double)8.0, (double)0.0, (double)5.0, (double)9.0, (double)6.0, (double)6.0), Block.box((double)5.0, (double)0.0, (double)7.0, (double)6.0, (double)3.0, (double)9.0), Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0), Block.box((double)7.75, (double)8.0, (double)7.75, (double)8.25, (double)10.0, (double)8.25)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public MapCodec<LargeCandleBlock> codec() {
        return CODEC;
    }

    public LargeCandleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)CANDLES, (Comparable)Integer.valueOf(1))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player.getAbilities().mayBuild) {
            if (stack.isEmpty() && ((Boolean)state.getValue((Property)LIT)).booleanValue()) {
                LargeCandleBlock.extinguish((Player)player, (BlockState)state, (LevelAccessor)level, (BlockPos)pos);
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (stack.getItem() == Items.TORCH.asItem()) {
                if (this.canBeLit(state)) {
                    level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true))).setValue((Property)CANDLES, (Comparable)Integer.valueOf(1)), 1);
                } else {
                    level.setBlock(pos, (BlockState)state.setValue((Property)CANDLES, (Comparable)Integer.valueOf(1)), 11);
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (stack.getItem() == Items.SOUL_TORCH.asItem()) {
                if (this.canBeLit(state)) {
                    level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true))).setValue((Property)CANDLES, (Comparable)Integer.valueOf(2)), 1);
                } else {
                    level.setBlock(pos, (BlockState)state.setValue((Property)CANDLES, (Comparable)Integer.valueOf(2)), 11);
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (stack.getItem() == Items.REDSTONE_TORCH.asItem()) {
                if (this.canBeLit(state)) {
                    level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true))).setValue((Property)CANDLES, (Comparable)Integer.valueOf(3)), 1);
                } else {
                    level.setBlock(pos, (BlockState)state.setValue((Property)CANDLES, (Comparable)Integer.valueOf(3)), 11);
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (stack.getItem() == OccultismItems.SPIRIT_TORCH.asItem()) {
                if (this.canBeLit(state)) {
                    level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true))).setValue((Property)CANDLES, (Comparable)Integer.valueOf(4)), 1);
                } else {
                    level.setBlock(pos, (BlockState)state.setValue((Property)CANDLES, (Comparable)Integer.valueOf(4)), 11);
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        boolean flag = fluidstate.getType() == Fluids.WATER;
        return (BlockState)super.getStateForPlacement(context).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    protected BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, neighborState, level, pos, neighborPos);
    }

    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{LIT, WATERLOGGED, CANDLES});
        super.createBlockStateDefinition(builder);
    }

    public boolean placeLiquid(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        if (!((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue() && fluidState.getType() == Fluids.WATER) {
            BlockState blockstate = (BlockState)state.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
            if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
                LargeCandleBlock.extinguish(null, (BlockState)blockstate, (LevelAccessor)level, (BlockPos)pos);
            } else {
                level.setBlock(pos, blockstate, 3);
            }
            level.scheduleTick(pos, fluidState.getType(), fluidState.getType().getTickDelay((LevelReader)level));
            return true;
        }
        return false;
    }

    protected Iterable<Vec3> getParticleOffsets(BlockState state) {
        return (Iterable)PARTICLE_OFFSETS.get(1);
    }

    protected boolean canBeLit(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) == false && super.canBeLit(state);
    }

    public void neighborChanged(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!this.canSurvive(state, (LevelReader)worldIn, pos)) {
            LargeCandleBlock.dropResources((BlockState)state, (Level)worldIn, (BlockPos)pos);
            worldIn.removeBlock(pos, false);
        }
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos down = pos.below();
        BlockState downState = worldIn.getBlockState(down);
        return downState.isFaceSturdy((BlockGetter)worldIn, down, Direction.UP);
    }

    public float getEnchantPowerBonus(BlockState state, LevelReader level, BlockPos pos) {
        return 1.0f;
    }

    public void animateTick(BlockState state, Level level, BlockPos blockPos, RandomSource rand) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            double d0 = (double)blockPos.getX() + 0.5;
            double d1 = (double)blockPos.getY() + 0.7;
            double d2 = (double)blockPos.getZ() + 0.5;
            float f = rand.nextFloat();
            if (f < 0.9f) {
                switch ((Integer)state.getValue((Property)CANDLES)) {
                    case 1: {
                        level.addParticle((ParticleOptions)ParticleTypes.FLAME, d0, d1, d2, 0.0, 0.0, 0.0);
                        if (!(f < 0.24f)) break;
                        level.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1, d2, 0.0, 0.0, 0.0);
                        break;
                    }
                    case 2: {
                        level.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, d0, d1, d2, 0.0, 0.0, 0.0);
                        if (!(f < 0.24f)) break;
                        level.addParticle((ParticleOptions)ParticleTypes.SOUL, d0, d1, d2, 0.0, 0.09, 0.0);
                        break;
                    }
                    case 3: {
                        level.addParticle((ParticleOptions)OccultismParticles.RED_FIRE_FLAME.get(), d0, d1, d2, 0.0, 0.0, 0.0);
                        if (!(f < 0.24f)) break;
                        level.addParticle((ParticleOptions)ParticleTypes.TRIAL_SPAWNER_DETECTED_PLAYER, d0, d1, d2, 0.0, -0.03, 0.0);
                        break;
                    }
                    case 4: {
                        level.addParticle((ParticleOptions)OccultismParticles.SPIRIT_FIRE_FLAME.get(), d0, d1, d2, 0.0, 0.0, 0.0);
                        if (!(f < 0.24f)) break;
                        level.addParticle((ParticleOptions)ParticleTypes.DRAGON_BREATH, d0, d1, d2, 0.0, 0.02, 0.0);
                    }
                }
            }
        }
    }
}

