/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.spirit.demonicpartner.wife;

import com.klikli_dev.occultism.common.entity.spirit.demonicpartner.DemonicPartner;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.Lazy;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class DemonicWife
extends DemonicPartner
implements GeoEntity {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"demonic_wife");
    public static final Lazy<EntityType<DemonicWife>> ENTITY_TYPE = Lazy.of(() -> EntityType.Builder.of(DemonicWife::new, (MobCategory)MobCategory.CREATURE).sized(0.6f, 2.0f).fireImmune().clientTrackingRange(8).build(ID.toString()));
    AnimatableInstanceCache animatableInstanceCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    protected DemonicWife(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public int getCurrentSwingDuration() {
        return 11;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController mainController = new AnimationController((GeoAnimatable)this, "mainController", 0, this::animPredicate);
        controllers.add(mainController);
    }

    private <T extends GeoAnimatable> PlayState animPredicate(AnimationState<T> tAnimationState) {
        if (this.swinging) {
            return tAnimationState.setAndContinue(RawAnimation.begin().thenPlay("attack"));
        }
        if (this.isInSittingPose()) {
            return tAnimationState.setAndContinue(RawAnimation.begin().thenPlay("sit"));
        }
        if (this.isLying()) {
            return tAnimationState.setAndContinue(RawAnimation.begin().thenPlay("lies"));
        }
        return tAnimationState.setAndContinue(tAnimationState.isMoving() ? RawAnimation.begin().thenPlay("walk") : RawAnimation.begin().thenPlay("idle"));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.animatableInstanceCache;
    }
}

