/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.handlers;

import com.klikli_dev.occultism.Occultism;
import com.klikli_dev.occultism.client.gui.satchel.SatchelScreen;
import com.klikli_dev.occultism.client.gui.storage.StorageRemoteGui;
import com.klikli_dev.occultism.handlers.ClientSetupEventHandler;
import com.klikli_dev.occultism.network.Networking;
import com.klikli_dev.occultism.network.messages.MessageDoubleJump;
import com.klikli_dev.occultism.network.messages.MessageOpenSatchel;
import com.klikli_dev.occultism.network.messages.MessageOpenStorageRemote;
import com.klikli_dev.occultism.network.messages.MessageToggleFamiliarSettings;
import com.klikli_dev.occultism.registry.OccultismBlocks;
import com.klikli_dev.occultism.registry.OccultismSounds;
import com.klikli_dev.occultism.util.CuriosUtil;
import com.klikli_dev.occultism.util.MovementUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.event.PlayLevelSoundEvent;

@EventBusSubscriber(modid="occultism", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class ClientPlayerEventHandler {
    @SubscribeEvent
    public static void onPlaySoundAt(PlayLevelSoundEvent.AtPosition event) {
        if (event.getLevel().isClientSide && ((Boolean)Occultism.CLIENT_CONFIG.misc.disableSpiritFireSuccessSound.get()).booleanValue() && event.getSound().value() == OccultismSounds.START_RITUAL.get() && event.getLevel().getBlockState(BlockPos.containing((Position)event.getPosition())).getBlock() == OccultismBlocks.SPIRIT_FIRE.get()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientPlayerEventHandler.checkBackpackKey((InputEvent)event);
        ClientPlayerEventHandler.checkStorageRemoteKey((InputEvent)event);
        ClientPlayerEventHandler.checkFamiliarSettingsKeys((InputEvent)event);
        if (event.getAction() == 1 && minecraft.options.keyJump.isDown() && minecraft.player != null && MovementUtil.doubleJump((Player)minecraft.player)) {
            Networking.sendToServer(new MessageDoubleJump());
        }
    }

    @SubscribeEvent
    public static void onMouseInput(InputEvent.Key event) {
        ClientPlayerEventHandler.checkBackpackKey((InputEvent)event);
        ClientPlayerEventHandler.checkStorageRemoteKey((InputEvent)event);
        ClientPlayerEventHandler.checkFamiliarSettingsKeys((InputEvent)event);
    }

    public static void checkBackpackKey(InputEvent event) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.screen instanceof SatchelScreen && ClientSetupEventHandler.KEY_BACKPACK.consumeClick()) {
            minecraft.player.closeContainer();
        } else if (minecraft.player != null & minecraft.screen == null && ClientSetupEventHandler.KEY_BACKPACK.consumeClick() && (!CuriosUtil.getBackpack((Player)minecraft.player).isEmpty() || CuriosUtil.getFirstBackpackSlot((Player)minecraft.player) > 0)) {
            Networking.sendToServer(new MessageOpenSatchel());
            minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundEvents.ARMOR_EQUIP_LEATHER.value()), (float)0.75f, (float)1.0f));
        }
    }

    public static void checkStorageRemoteKey(InputEvent event) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.screen instanceof StorageRemoteGui && ClientSetupEventHandler.KEY_STORAGE_REMOTE.consumeClick()) {
            minecraft.player.closeContainer();
        } else if (minecraft.player != null & minecraft.screen == null && ClientSetupEventHandler.KEY_STORAGE_REMOTE.consumeClick() && (!CuriosUtil.getStorageRemoteCurio((Player)minecraft.player).isEmpty() || CuriosUtil.getFirstStorageRemoteSlot((Player)minecraft.player) > 0)) {
            Networking.sendToServer(new MessageOpenStorageRemote());
            minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundEvents.ARMOR_EQUIP_DIAMOND.value()), (float)0.75f, (float)1.0f));
        }
    }

    public static void checkFamiliarSettingsKeys(InputEvent event) {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player != null & minecraft.screen == null) {
            boolean familiarKeyPressed = false;
            HashMap familiarsPressed = new HashMap();
            for (Map.Entry<EntityType<?>, KeyMapping> entry : ClientSetupEventHandler.keysFamiliars.entrySet()) {
                boolean isPressed = entry.getValue().consumeClick();
                if (isPressed) {
                    familiarKeyPressed = true;
                }
                familiarsPressed.put(entry.getKey(), isPressed);
            }
            if (familiarKeyPressed) {
                Networking.sendToServer(new MessageToggleFamiliarSettings(familiarsPressed));
            }
        }
    }
}

