/*
 * Decompiled with CFR 0.152.
 */
package toni.immersivemessages.api;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.Nullable;
import toni.SoundUtil;
import toni.immersivemessages.ImmersiveFont;
import toni.immersivemessages.ImmersiveMessages;
import toni.immersivemessages.ImmersiveMessagesManager;
import toni.immersivemessages.api.ObfuscateMode;
import toni.immersivemessages.api.OnPoseMessage;
import toni.immersivemessages.api.OnRenderMessage;
import toni.immersivemessages.api.OnRenderMessageCaxton;
import toni.immersivemessages.api.SoundEffect;
import toni.immersivemessages.api.TextAnchor;
import toni.immersivemessages.networking.TooltipPacket;
import toni.immersivemessages.util.ImmersiveColor;
import toni.lib.animation.AnimationTimeline;
import toni.lib.animation.Binding;
import toni.lib.animation.easing.EasingType;
import toni.lib.utils.VersionUtils;

public class ImmersiveMessage {
    public Style style = Style.EMPTY;
    private MutableComponent text;
    public AnimationTimeline animation;
    public ImmersiveMessage subtext;
    public ImmersiveMessage parent;
    public boolean shadow = true;
    public boolean border;
    public float yLevel = 55.0f;
    public float xLevel = 0.0f;
    public float delay = 0.0f;
    private ObfuscateMode obfuscateMode = ObfuscateMode.NONE;
    private float obfuscateSpeed = 1.0f;
    public boolean typewriter = false;
    public boolean typewriterCenterAligned = false;
    public float typewriterSpeed = 1.0f;
    public MutableComponent typewriterCurrent = Component.literal((String)"");
    public SoundEffect soundEffect = SoundEffect.NONE;
    private float typewriterTicks;
    private int typewriterTimes = 1;
    private float obfuscateTicks;
    private int obfuscateTimes = 1;
    public TextAnchor anchor = TextAnchor.CENTER_CENTER;
    public TextAnchor align = TextAnchor.CENTER_CENTER;
    public int wrapMaxWidth = -1;
    public boolean background = false;
    public ImmersiveColor colorBackground = ImmersiveColor.BLACK.copy();
    public ImmersiveColor colorBorderTop = new ImmersiveColor(36, 1, 89, 255).mixWith(ImmersiveColor.WHITE, 0.1f);
    public ImmersiveColor colorBorderBot = new ImmersiveColor(25, 1, 53, 255);
    public float rainbow = -1.0f;
    public OnPoseMessage onPoseMessage;
    public OnRenderMessage onRenderMessage;
    public OnRenderMessageCaxton onRenderMessageCaxton;
    public static final StreamCodec<ByteBuf, ImmersiveMessage> CODEC = new StreamCodec<ByteBuf, ImmersiveMessage>(){

        public ImmersiveMessage decode(ByteBuf byteBuf) {
            return ImmersiveMessage.decode(byteBuf);
        }

        public void encode(ByteBuf byteBuf, ImmersiveMessage tooltip) {
            tooltip.encode(byteBuf);
        }
    };

    private ImmersiveMessage() {
    }

    private void encode(ByteBuf buffer) {
        FriendlyByteBuf buf = new FriendlyByteBuf(buffer);
        buf.writeJsonWithCodec(Style.Serializer.CODEC, (Object)this.style);
        String str = Component.Serializer.toJson((Component)this.text, (HolderLookup.Provider)RegistryAccess.EMPTY);
        buf.writeUtf(str);
        this.animation.encode(buf);
        buf.writeBoolean(this.subtext != null);
        if (this.subtext != null) {
            this.subtext.encode((ByteBuf)buf);
        }
        buf.writeBoolean(this.shadow);
        buf.writeBoolean(this.border);
        buf.writeFloat(this.yLevel);
        buf.writeFloat(this.xLevel);
        buf.writeFloat(this.delay);
        buf.writeEnum((Enum)this.obfuscateMode);
        buf.writeFloat(this.obfuscateSpeed);
        buf.writeEnum((Enum)this.soundEffect);
        buf.writeBoolean(this.typewriter);
        buf.writeBoolean(this.typewriterCenterAligned);
        buf.writeFloat(this.typewriterSpeed);
        buf.writeEnum((Enum)this.anchor);
        buf.writeEnum((Enum)this.align);
        buf.writeInt(this.wrapMaxWidth);
        buf.writeBoolean(this.background);
        buf.writeInt(this.colorBackground.getRGB());
        buf.writeInt(this.colorBorderTop.getRGB());
        buf.writeInt(this.colorBorderBot.getRGB());
        buf.writeFloat(this.rainbow);
    }

    private static ImmersiveMessage decode(ByteBuf buffer) {
        FriendlyByteBuf buf = new FriendlyByteBuf(buffer);
        ImmersiveMessage ths = new ImmersiveMessage();
        ths.style = (Style)buf.readJsonWithCodec(Style.Serializer.CODEC);
        String str = buf.readUtf();
        ths.text = Component.Serializer.fromJson((String)str, (HolderLookup.Provider)RegistryAccess.EMPTY);
        ths.animation = AnimationTimeline.decode((FriendlyByteBuf)buf);
        boolean hasSubtext = buf.readBoolean();
        if (hasSubtext) {
            ths.subtext = ImmersiveMessage.decode((ByteBuf)buf);
            ths.subtext.parent = ths;
        }
        ths.shadow = buf.readBoolean();
        ths.border = buf.readBoolean();
        ths.yLevel = buf.readFloat();
        ths.xLevel = buf.readFloat();
        ths.delay = buf.readFloat();
        ths.obfuscateMode = (ObfuscateMode)buf.readEnum(ObfuscateMode.class);
        ths.obfuscateSpeed = buf.readFloat();
        ths.soundEffect = (SoundEffect)buf.readEnum(SoundEffect.class);
        ths.typewriter = buf.readBoolean();
        ths.typewriterCenterAligned = buf.readBoolean();
        ths.typewriterSpeed = buf.readFloat();
        ths.anchor = (TextAnchor)buf.readEnum(TextAnchor.class);
        ths.align = (TextAnchor)buf.readEnum(TextAnchor.class);
        ths.wrapMaxWidth = buf.readInt();
        ths.background = buf.readBoolean();
        ths.colorBackground = new ImmersiveColor(buf.readInt());
        ths.colorBorderTop = new ImmersiveColor(buf.readInt());
        ths.colorBorderBot = new ImmersiveColor(buf.readInt());
        ths.rainbow = buf.readFloat();
        return ths;
    }

    public static ImmersiveMessage builder(float duration, String text) {
        ImmersiveMessage tooltip = new ImmersiveMessage();
        tooltip.text = Component.literal((String)text);
        tooltip.style = Style.EMPTY;
        tooltip.animation = AnimationTimeline.builder((float)duration);
        tooltip.animation.withYPosition(tooltip.yLevel);
        return tooltip;
    }

    public static ImmersiveMessage builder(float duration, MutableComponent text) {
        ImmersiveMessage tooltip = new ImmersiveMessage();
        tooltip.text = text;
        tooltip.style = Style.EMPTY;
        tooltip.animation = AnimationTimeline.builder((float)duration);
        tooltip.animation.withYPosition(tooltip.yLevel);
        return tooltip;
    }

    public static ImmersiveMessage popup(float duration, String title, String subtitle) {
        return ImmersiveMessage.builder(duration, title).anchor(TextAnchor.CENTER_CENTER).wrap(200).size(1.0f).background().slideUp(0.3f).slideOutDown(0.3f).fadeIn(0.5f).fadeOut(0.5f).color(ChatFormatting.GOLD).style((Style style) -> style.withUnderlined(Boolean.valueOf(true))).subtext(0.0f, subtitle, 8.0f, subtext -> subtext.anchor(TextAnchor.CENTER_CENTER).wrap(200).size(1.0f).slideUp(0.3f).slideOutDown(0.3f).fadeIn(0.5f).fadeOut(0.5f));
    }

    public static ImmersiveMessage toast(float duration, String title, String subtitle) {
        return ImmersiveMessage.builder(duration, title).anchor(TextAnchor.TOP_LEFT).wrap().y(10.0f).x(10.0f).size(1.0f).background().slideLeft(0.3f).slideOutRight(0.3f).fadeIn(0.5f).fadeOut(0.5f).color(ChatFormatting.GOLD).style((Style style) -> style.withUnderlined(Boolean.valueOf(true))).subtext(0.0f, subtitle, 11.0f, subtext -> subtext.anchor(TextAnchor.TOP_LEFT).wrap().x(10.0f).size(1.0f).slideLeft(0.3f).slideOutRight(0.3f).fadeIn(0.5f).fadeOut(0.5f));
    }

    public void render(GuiGraphics graphics, float deltaTicks) {
        this.render(graphics, deltaTicks, 0);
    }

    private void render(GuiGraphics graphics, float deltaTicks, int depth) {
        this.tick(deltaTicks);
        this.animation.advancePlayhead(deltaTicks / 20.0f);
        if (depth == 0 && this.animation.getCurrent() >= this.animation.duration) {
            return;
        }
        ImmersiveMessagesManager.getRenderer().render(this, graphics, deltaTicks);
        if (this.subtext != null) {
            this.subtext.render(graphics, deltaTicks, depth + 1);
        }
    }

    public MutableComponent getText() {
        if (this.typewriter) {
            return this.typewriterCurrent.withStyle(this.style);
        }
        return this.text.withStyle(this.style);
    }

    public MutableComponent getRawText() {
        return this.text.withStyle(this.style);
    }

    public ImmersiveMessage typewriter(float speed, boolean centerAligned) {
        this.typewriterSpeed = speed;
        this.typewriterCurrent = Component.literal((String)"");
        this.typewriterCenterAligned = centerAligned;
        this.typewriter = true;
        return this;
    }

    public ImmersiveMessage background() {
        this.background = true;
        return this;
    }

    public ImmersiveMessage rainbow() {
        return this.rainbow(2.0f);
    }

    public ImmersiveMessage rainbow(float speed) {
        this.background = true;
        this.rainbow = speed * 20.0f;
        return this;
    }

    public ImmersiveMessage backgroundColor(int color) {
        return this.backgroundColor(new ImmersiveColor(color));
    }

    public ImmersiveMessage backgroundColor(ImmersiveColor color) {
        this.colorBackground = color;
        return this;
    }

    public ImmersiveMessage borderTopColor(int color) {
        return this.borderTopColor(new ImmersiveColor(color));
    }

    public ImmersiveMessage borderTopColor(ImmersiveColor color) {
        this.colorBorderTop = color;
        return this;
    }

    public ImmersiveMessage borderBottomColor(int color) {
        return this.borderBottomColor(new ImmersiveColor(color));
    }

    public ImmersiveMessage borderBottomColor(ImmersiveColor color) {
        this.colorBorderBot = color;
        return this;
    }

    public ImmersiveMessage wrap(int maxWidth) {
        this.wrapMaxWidth = maxWidth;
        return this;
    }

    public ImmersiveMessage wrap() {
        this.wrapMaxWidth = 0;
        return this;
    }

    public ImmersiveMessage anchor(TextAnchor anchor) {
        this.anchor = anchor;
        return this;
    }

    public ImmersiveMessage align(TextAnchor anchor) {
        this.align = anchor;
        return this;
    }

    public ImmersiveMessage sound(SoundEffect effect) {
        this.soundEffect = effect;
        return this;
    }

    public ImmersiveMessage apply(Consumer<ImmersiveMessage> consumer) {
        consumer.accept(this);
        return this;
    }

    public ImmersiveMessage subtext(float delay, String subtext, Consumer<ImmersiveMessage> builder) {
        return this.subtext(delay, subtext, 10.0f, builder);
    }

    public ImmersiveMessage subtext(float delay, String subtext, float offset, Consumer<ImmersiveMessage> builder) {
        this.subtext = ImmersiveMessage.builder(this.animation.duration, subtext);
        this.subtext.delay = delay;
        this.subtext.y(this.yLevel + offset);
        this.subtext.size(0.75f);
        this.subtext.parent = this;
        builder.accept(this.subtext);
        return this;
    }

    public ImmersiveMessage y(float ylevel) {
        this.yLevel = ylevel;
        this.animation.withYPosition(ylevel);
        return this;
    }

    public ImmersiveMessage x(float xlevel) {
        this.xLevel = xlevel;
        this.animation.withXPosition(xlevel);
        return this;
    }

    public ImmersiveMessage bold() {
        return this.style((Style style) -> style.withBold(Boolean.valueOf(true)));
    }

    public ImmersiveMessage italic() {
        return this.style((Style style) -> style.withItalic(Boolean.valueOf(true)));
    }

    public ImmersiveMessage size(float size) {
        this.animation.withSize(size);
        return this;
    }

    public ImmersiveMessage fadeIn() {
        return this.fadeIn(1.0f);
    }

    public ImmersiveMessage fadeIn(float duration) {
        this.animation.transition(Binding.Alpha, this.delay, this.delay + duration, 0.0f, 1.0f, EasingType.EaseOutSine);
        return this;
    }

    public ImmersiveMessage fadeOut() {
        return this.fadeOut(1.0f);
    }

    public ImmersiveMessage fadeOut(float duration) {
        this.animation.fadeout(duration);
        return this;
    }

    public ImmersiveMessage shake() {
        return this.shake(100.0f, 0.75f);
    }

    public ImmersiveMessage shake(float speed, float intensity) {
        this.animation.waveEffect(Binding.xPos, intensity, speed, 0.0f, this.animation.duration);
        this.animation.waveEffect(Binding.yPos, intensity, speed * 0.95f, 0.0f, this.animation.duration);
        return this;
    }

    public ImmersiveMessage wave() {
        return this.wave(5.0f, 2.5f);
    }

    public ImmersiveMessage wave(float speed, float intensity) {
        this.animation.waveEffect(Binding.zRot, intensity, speed, 0.0f, this.animation.duration);
        return this;
    }

    public ImmersiveMessage slideUp() {
        return this.slideUp(1.0f);
    }

    public ImmersiveMessage slideUp(float duration) {
        this.animation.transition(Binding.yPos, this.delay, this.delay + duration, this.yLevel + 50.0f, this.yLevel, EasingType.EaseOutCubic);
        return this;
    }

    public ImmersiveMessage slideDown() {
        return this.slideDown(1.0f);
    }

    public ImmersiveMessage slideDown(float duration) {
        this.animation.transition(Binding.yPos, this.delay, this.delay + duration, this.yLevel - 50.0f, this.yLevel, EasingType.EaseOutCubic);
        return this;
    }

    public ImmersiveMessage slideLeft() {
        return this.slideLeft(1.0f);
    }

    public ImmersiveMessage slideLeft(float duration) {
        this.animation.transition(Binding.xPos, this.delay, this.delay + duration, this.xLevel - 50.0f, this.xLevel, EasingType.EaseOutCubic);
        return this;
    }

    public ImmersiveMessage slideRight() {
        return this.slideRight(1.0f);
    }

    public ImmersiveMessage slideRight(float duration) {
        this.animation.transition(Binding.xPos, this.delay, this.delay + duration, this.xLevel + 50.0f, this.xLevel, EasingType.EaseOutCubic);
        return this;
    }

    public ImmersiveMessage slideOutUp() {
        return this.slideOutUp(1.0f);
    }

    public ImmersiveMessage slideOutUp(float duration) {
        this.animation.transition(Binding.yPos, this.animation.duration - duration, this.animation.duration, this.yLevel, this.yLevel - 50.0f, EasingType.EaseOutCubic);
        return this;
    }

    public ImmersiveMessage slideOutDown() {
        return this.slideOutDown(1.0f);
    }

    public ImmersiveMessage slideOutDown(float duration) {
        this.animation.transition(Binding.yPos, this.animation.duration - duration, this.animation.duration, this.yLevel, this.yLevel + 50.0f, EasingType.EaseOutCubic);
        return this;
    }

    public ImmersiveMessage slideOutLeft() {
        return this.slideOutLeft(1.0f);
    }

    public ImmersiveMessage slideOutLeft(float duration) {
        this.animation.transition(Binding.xPos, this.animation.duration - duration, this.animation.duration, this.xLevel, this.xLevel - 50.0f, EasingType.EaseOutCubic);
        return this;
    }

    public ImmersiveMessage slideOutRight() {
        return this.slideOutRight(1.0f);
    }

    public ImmersiveMessage slideOutRight(float duration) {
        this.animation.transition(Binding.xPos, this.animation.duration - duration, this.animation.duration, this.xLevel, this.xLevel + 50.0f, EasingType.EaseOutCubic);
        return this;
    }

    public ImmersiveMessage font(String font) {
        this.style = this.style.withFont(VersionUtils.resource((String)font));
        return this;
    }

    public ImmersiveMessage font(ImmersiveFont font) {
        this.style = this.style.withFont(font.getLocation());
        return this;
    }

    public ImmersiveMessage style(Style style) {
        this.style = style;
        return this;
    }

    public ImmersiveMessage style(Function<Style, Style> function) {
        this.style = function.apply(this.style);
        return this;
    }

    public ImmersiveMessage shadow(boolean shadow) {
        this.shadow = shadow;
        return this;
    }

    public ImmersiveMessage animation(Consumer<AnimationTimeline> animationBuilder) {
        animationBuilder.accept(this.animation);
        return this;
    }

    public void sendLocal(LocalPlayer player) {
        ImmersiveMessages.showToPlayer(player, this);
    }

    public void sendServer(ServerPlayer player) {
        new TooltipPacket(this).send(player);
    }

    public void sendServer(Collection<ServerPlayer> players) {
        players.forEach(this::sendServer);
    }

    public void sendServerToAll(MinecraftServer server) {
        new TooltipPacket(this).sendToAll(server);
    }

    public ImmersiveMessage obfuscate() {
        return this.obfuscate(ObfuscateMode.RANDOM, 1.0f);
    }

    public ImmersiveMessage obfuscate(float speed) {
        return this.obfuscate(ObfuscateMode.RANDOM, speed);
    }

    public ImmersiveMessage obfuscate(ObfuscateMode mode) {
        return this.obfuscate(mode, 1.0f);
    }

    public ImmersiveMessage obfuscate(ObfuscateMode mode, float speed) {
        this.obfuscateMode = mode;
        this.obfuscateSpeed = speed;
        StringBuilder sb = new StringBuilder();
        String str = this.text.getString();
        for (char chr : str.toCharArray()) {
            sb.append("\u00a7k");
            sb.append(chr);
            sb.append("\u00a7r");
        }
        this.text = Component.literal((String)sb.toString());
        return this;
    }

    public ImmersiveMessage color(@Nullable TextColor color) {
        return this.style((Style style) -> style.withColor(color));
    }

    public ImmersiveMessage color(@Nullable ChatFormatting formatting) {
        return this.style((Style style) -> style.withColor(formatting));
    }

    public ImmersiveMessage color(int rgb) {
        return this.style((Style style) -> style.withColor(rgb));
    }

    public void tick(float delta) {
        this.tickObfuscation(delta);
        this.tickTypewriter(delta);
    }

    private void tickTypewriter(float delta) {
        String str = this.text.getString();
        if (this.typewriterTimes > str.length()) {
            return;
        }
        this.typewriterTicks += delta;
        if (!(this.typewriterTicks > (float)this.typewriterTimes * (1.0f / this.typewriterSpeed))) {
            return;
        }
        ++this.typewriterTimes;
        String current = str.substring(0, Math.min(str.length(), this.typewriterTimes));
        this.typewriterCurrent = Component.literal((String)current);
        char lastChar = current.charAt(current.length() - 1);
        if (lastChar == ',') {
            this.typewriterTicks -= 3.0f / this.typewriterSpeed;
            return;
        }
        if (lastChar == '.') {
            this.typewriterTicks -= 5.0f * (1.0f / this.typewriterSpeed);
            return;
        }
        if (lastChar == '\u00a7') {
            this.typewriterTicks -= 5.0f * (1.0f / this.typewriterSpeed);
            return;
        }
        if (lastChar == ' ') {
            this.typewriterTicks += 1.0f / this.typewriterSpeed;
            ++this.typewriterTimes;
            this.typewriterCurrent = Component.literal((String)str.substring(0, Math.min(str.length(), this.typewriterTimes)));
        }
        if (this.soundEffect != SoundEffect.NONE) {
            SoundUtil.playSoundEffect(this);
        }
    }

    private void tickObfuscation(float delta) {
        this.obfuscateTicks += delta;
        if (!(this.obfuscateTicks > (float)this.obfuscateTimes * (1.0f / this.obfuscateSpeed))) {
            return;
        }
        String str = this.text.getString();
        ++this.obfuscateTimes;
        switch (this.obfuscateMode) {
            case LEFT: {
                this.text = Component.literal((String)str.replaceFirst("\u00a7k", ""));
                break;
            }
            case RIGHT: {
                int index = str.lastIndexOf("\u00a7k");
                if (index == -1) break;
                this.text = Component.literal((String)(str.substring(0, index) + str.substring(index + 2)));
                break;
            }
            case CENTER: {
                int index = this.getClosestIndexToCenter(str, "\u00a7k");
                if (index == -1) break;
                this.text = Component.literal((String)(str.substring(0, index) + str.substring(index + 2)));
                break;
            }
            case RANDOM: {
                ArrayList<Integer> occurrences = new ArrayList<Integer>();
                for (int i = 0; i <= str.length() - 2; ++i) {
                    if (!str.startsWith("\u00a7k", i)) continue;
                    occurrences.add(i);
                }
                if (occurrences.isEmpty()) break;
                Random rand = new Random();
                int index = (Integer)occurrences.get(rand.nextInt(occurrences.size()));
                this.text = Component.literal((String)(str.substring(0, index) + str.substring(index + 2)));
            }
        }
    }

    private int getClosestIndexToCenter(String str, String target) {
        int centerIndex = str.length() / 2;
        int closestIndex = -1;
        int minDistance = Integer.MAX_VALUE;
        for (int i = 0; i <= str.length() - target.length(); ++i) {
            int distanceFromCenter;
            if (!str.substring(i, i + target.length()).equals(target) || (distanceFromCenter = Math.abs(i - centerIndex)) >= minDistance) continue;
            closestIndex = i;
            minDistance = distanceFromCenter;
        }
        return closestIndex;
    }
}

