/*
 * Decompiled with CFR 0.152.
 */
package toni.immersivemessages.renderers;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FastColor;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import org.joml.Vector3i;
import toni.immersivemessages.api.ImmersiveMessage;
import toni.immersivemessages.renderers.ITooltipRenderer;
import toni.immersivemessages.util.AnimationUtil;
import toni.immersivemessages.util.RenderUtil;

public class VanillaRenderer
implements ITooltipRenderer {
    @Override
    public void render(ImmersiveMessage tooltip, GuiGraphics graphics, float deltaTicks) {
        Font font = Minecraft.getInstance().font;
        ArrayList<FormattedText> textLines = new ArrayList<FormattedText>();
        textLines.add((FormattedText)tooltip.getText());
        Vector3i size = VanillaRenderer.wrapText(textLines, tooltip, false);
        Vector2i bgOffset = tooltip.anchor.getNormalized();
        bgOffset = bgOffset.add((Vector2ic)tooltip.align.getNormalized().mul(-1));
        if (tooltip.background) {
            RenderUtil.drawBackground(tooltip, graphics, size, bgOffset.mul(-3, new Vector2i()), deltaTicks);
        }
        int yOffset = 0;
        float fade = (float)FastColor.ARGB32.alpha((int)tooltip.animation.getColor()) / 255.0f;
        MultiBufferSource.BufferSource renderType = graphics.bufferSource();
        for (int lineNumber = 0; lineNumber < textLines.size(); ++lineNumber) {
            FormattedText line = textLines.get(lineNumber);
            if (line != null) {
                float lineWidth;
                graphics.pose().pushPose();
                float f = tooltip.typewriter && !tooltip.typewriterCenterAligned ? this.getTypewriterWidth(graphics, tooltip, (FormattedText)(textLines.size() == 1 ? tooltip.getRawText() : line)) : (lineWidth = (float)font.width(line));
                if (tooltip.onPoseMessage != null) {
                    tooltip.onPoseMessage.applyPose(tooltip, tooltip.animation, graphics, bgOffset.mul(-6, new Vector2i()), tooltip.anchor, tooltip.align, lineWidth, size.y);
                } else {
                    AnimationUtil.applyPose(tooltip.animation, graphics, bgOffset.mul(-6, new Vector2i()), tooltip.anchor, tooltip.align, lineWidth, size.y);
                }
                if (tooltip.onRenderMessage != null) {
                    tooltip.onRenderMessage.render(tooltip, graphics, line, yOffset);
                } else {
                    font.drawInBatch(Language.getInstance().getVisualOrder(line), 0.0f, (float)yOffset, FastColor.ARGB32.color((int)((int)Math.max(0.0f, Math.min(255.0f, fade * 255.0f))), (int)255, (int)255, (int)255), tooltip.shadow, graphics.pose().last().pose(), (MultiBufferSource)renderType, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                }
                graphics.pose().popPose();
            }
            yOffset += 10;
        }
        graphics.flush();
    }

    private static Vector3i wrapText(ArrayList<FormattedText> textLines, ImmersiveMessage tooltip, boolean isCallingFromRoot) {
        if (tooltip.parent == null || isCallingFromRoot) {
            Vector3i size = RenderUtil.wrapText(textLines, tooltip.wrapMaxWidth, line -> Minecraft.getInstance().font.width(line));
            if (tooltip.subtext != null) {
                ArrayList<FormattedText> subtextLines = new ArrayList<FormattedText>();
                subtextLines.add((FormattedText)tooltip.subtext.getText());
                Vector3i subtextSize = VanillaRenderer.wrapText(subtextLines, tooltip.subtext, true);
                float yOffset = Math.max(0.0f, tooltip.subtext.yLevel - tooltip.yLevel);
                float xOffset = Math.max(0.0f, tooltip.subtext.xLevel - tooltip.xLevel);
                return new Vector3i(Math.max(size.x, (int)xOffset + subtextSize.x), Math.max(size.y, (int)yOffset + subtextSize.y), Math.max(size.z, subtextSize.z));
            }
            return size;
        }
        return VanillaRenderer.wrapText(textLines, tooltip.parent, false);
    }

    private float getTypewriterWidth(GuiGraphics graphics, ImmersiveMessage tooltip, FormattedText line) {
        if (tooltip.wrapMaxWidth >= 0) {
            return tooltip.wrapMaxWidth == 0 ? (float)graphics.guiWidth() / 2.0f : Math.max((float)tooltip.wrapMaxWidth, (float)graphics.guiWidth() / 2.0f);
        }
        return Minecraft.getInstance().font.width(line);
    }
}

